/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.impl;

import javax.annotation.Nullable;
import org.gradle.internal.enterprise.GradleEnterprisePluginCheckInResult;
import org.gradle.internal.enterprise.GradleEnterprisePluginCheckInService;
import org.gradle.internal.enterprise.GradleEnterprisePluginMetadata;
import org.gradle.internal.enterprise.GradleEnterprisePluginServiceFactory;
import org.gradle.internal.enterprise.GradleEnterprisePluginServiceRef;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginAdapter;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.enterprise.impl.DefaultGradleEnterprisePluginAdapter;

public class DefautGradleEnterprisePluginCheckInService
implements GradleEnterprisePluginCheckInService {
    private final GradleEnterprisePluginManager manager;
    private final DefaultGradleEnterprisePluginAdapter adapter;
    public static final String UNSUPPORTED_TOGGLE = "org.gradle.internal.unsupported-enterprise-plugin";
    public static final String UNSUPPORTED_TOGGLE_MESSAGE = "Enterprise plugin unsupported due to secret toggle";

    public DefautGradleEnterprisePluginCheckInService(GradleEnterprisePluginManager manager, DefaultGradleEnterprisePluginAdapter adapter) {
        this.manager = manager;
        this.adapter = adapter;
    }

    @Override
    public GradleEnterprisePluginCheckInResult checkIn(GradleEnterprisePluginMetadata pluginMetadata, GradleEnterprisePluginServiceFactory serviceFactory) {
        if (Boolean.getBoolean(UNSUPPORTED_TOGGLE)) {
            this.manager.unsupported();
            return new GradleEnterprisePluginCheckInResult(){

                @Override
                public String getUnsupportedMessage() {
                    return DefautGradleEnterprisePluginCheckInService.UNSUPPORTED_TOGGLE_MESSAGE;
                }

                @Override
                public GradleEnterprisePluginServiceRef getPluginServiceRef() {
                    throw new IllegalStateException();
                }
            };
        }
        final GradleEnterprisePluginServiceRef ref = this.adapter.register(serviceFactory);
        this.manager.registerAdapter((GradleEnterprisePluginAdapter)this.adapter);
        return new GradleEnterprisePluginCheckInResult(){

            @Override
            @Nullable
            public String getUnsupportedMessage() {
                return null;
            }

            @Override
            public GradleEnterprisePluginServiceRef getPluginServiceRef() {
                return ref;
            }
        };
    }
}

