/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.lazy;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.internal.lazy.Lazy;

@NotThreadSafe
class UnsafeLazy<T>
implements Lazy<T> {
    private Supplier<T> supplier;
    private T value;

    public UnsafeLazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public T get() {
        return this.ensureValue();
    }

    private T ensureValue() {
        if (this.supplier != null) {
            this.value = this.supplier.get();
            this.supplier = null;
        }
        return this.value;
    }

    @Override
    public void use(Consumer<? super T> consumer) {
        consumer.accept(this.ensureValue());
    }

    @Override
    public <V> V apply(Function<? super T, V> function) {
        return function.apply(this.ensureValue());
    }
}

