/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.collect.ImmutableSet;
import org.gradle.internal.hash.Hashable;
import org.gradle.internal.hash.Hasher;

class AbstractSetSnapshot<T extends Hashable>
implements Hashable {
    protected final ImmutableSet<T> elements;

    public AbstractSetSnapshot(ImmutableSet<T> elements) {
        this.elements = elements;
    }

    public ImmutableSet<T> getElements() {
        return this.elements;
    }

    public void appendToHasher(Hasher hasher) {
        hasher.putString((CharSequence)"Set");
        hasher.putInt(this.elements.size());
        for (Hashable element : this.elements) {
            element.appendToHasher(hasher);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractSetSnapshot other = (AbstractSetSnapshot)obj;
        return this.elements.equals(other.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }
}

