/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.gradle.BuildListener;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.provider.action.BuildModelAction;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderLookup;

public class BuildModelActionRunner
implements BuildActionRunner {
    private final PayloadSerializer payloadSerializer;

    public BuildModelActionRunner(PayloadSerializer payloadSerializer) {
        this.payloadSerializer = payloadSerializer;
    }

    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        if (!(action instanceof BuildModelAction)) {
            return BuildActionRunner.Result.nothing();
        }
        BuildModelAction buildModelAction = (BuildModelAction)action;
        GradleInternal gradle = buildController.getGradle();
        ModelCreateAction createAction = new ModelCreateAction(buildModelAction);
        try {
            if (buildModelAction.isCreateModel()) {
                gradle.addBuildListener((BuildListener)new ForceFullConfigurationListener());
                Object result = buildController.fromBuildModel(buildModelAction.isRunTasks(), (Function)createAction);
                SerializedPayload serializedResult = this.payloadSerializer.serialize(result);
                return BuildActionRunner.Result.of((Object)serializedResult);
            }
            buildController.scheduleAndRunTasks();
            return BuildActionRunner.Result.of(null);
        }
        catch (RuntimeException e) {
            RuntimeException clientFailure = e;
            if (createAction.modelLookupFailure != null) {
                clientFailure = (RuntimeException)new InternalUnsupportedModelException().initCause((Throwable)createAction.modelLookupFailure);
            }
            return BuildActionRunner.Result.failed((Throwable)e, (RuntimeException)clientFailure);
        }
    }

    private static ToolingModelBuilderLookup getToolingModelBuilderRegistry(GradleInternal gradle) {
        return (ToolingModelBuilderLookup)gradle.getDefaultProject().getServices().get(ToolingModelBuilderLookup.class);
    }

    private static class ForceFullConfigurationListener
    extends InternalBuildAdapter {
        private ForceFullConfigurationListener() {
        }

        public void projectsEvaluated(Gradle gradle) {
            this.forceFullConfiguration((GradleInternal)gradle, new HashSet<GradleInternal>());
        }

        private void forceFullConfiguration(GradleInternal gradle, Set<GradleInternal> alreadyConfigured) {
            ((ProjectConfigurer)gradle.getServices().get(ProjectConfigurer.class)).configureHierarchyFully(gradle.getRootProject());
            for (IncludedBuildInternal reference : gradle.includedBuilds()) {
                GradleInternal build;
                BuildState target = reference.getTarget();
                if (!(target instanceof IncludedBuildState) || alreadyConfigured.contains(build = ((IncludedBuildState)target).getConfiguredBuild())) continue;
                alreadyConfigured.add(build);
                this.forceFullConfiguration(build, alreadyConfigured);
            }
        }
    }

    private static class ModelCreateAction
    implements Function<GradleInternal, Object> {
        private final BuildModelAction buildModelAction;
        private UnknownModelException modelLookupFailure;

        public ModelCreateAction(BuildModelAction buildModelAction) {
            this.buildModelAction = buildModelAction;
        }

        @Override
        public Object apply(GradleInternal gradle) {
            ToolingModelBuilderLookup.Builder builder;
            String modelName = this.buildModelAction.getModelName();
            ToolingModelBuilderLookup builderRegistry = BuildModelActionRunner.getToolingModelBuilderRegistry(gradle);
            try {
                builder = builderRegistry.locateForClientOperation(modelName, false, gradle);
            }
            catch (UnknownModelException e) {
                this.modelLookupFailure = e;
                throw e;
            }
            return builder.build(null);
        }
    }
}

