/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictingProjectionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkTypeRef", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "checkers"})
public final class FirConflictingProjectionChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirConflictingProjectionChecker INSTANCE = new FirConflictingProjectionChecker();

    private FirConflictingProjectionChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirDeclaration firDeclaration;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration2 instanceof FirPropertyAccessor) {
            return;
        }
        if (declaration2 instanceof FirTypedDeclaration) {
            if (declaration2.getResolvePhase() == FirResolvePhase.CONTRACTS) {
                return;
            }
            this.checkTypeRef(((FirTypedDeclaration)declaration2).getReturnTypeRef(), context2, reporter);
        }
        if ((firDeclaration = declaration2) instanceof FirClass) {
            for (FirTypeRef it : ((FirClass)declaration2).getSuperTypeRefs()) {
                this.checkTypeRef(it, context2, reporter);
            }
        } else if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeRef(((FirTypeAlias)declaration2).getExpandedTypeRef(), context2, reporter);
        }
    }

    private final void checkTypeRef(FirTypeRef typeRef, CheckerContext context2, DiagnosticReporter reporter) {
        FirRegularClass firRegularClass;
        Object object;
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        FirTypeRef $this$coneTypeSafe$iv = typeRef;
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag = (object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null ? null : ((ConeClassLikeType)object).getLookupTag();
        FirClassLikeDeclaration $this$safeAs$iv = coneClassLikeLookupTag == null ? null : ((object = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession())) == null ? null : (FirClassLikeDeclaration)((AbstractFirBasedSymbol)object).getFir());
        boolean $i$f$safeAs = false;
        FirClassLikeDeclaration firClassLikeDeclaration = $this$safeAs$iv;
        if (!(firClassLikeDeclaration instanceof FirRegularClass)) {
            firClassLikeDeclaration = null;
        }
        if ((firRegularClass = (FirRegularClass)firClassLikeDeclaration) == null) {
            return;
        }
        int n = 0;
        FirRegularClass declaration2 = firRegularClass;
        int size = ((Number)((Object)AddToStdlibKt.min(declaration2.getTypeParameters().size(), FirTypeUtilsKt.getConeType(typeRef).getTypeArguments().length))).intValue();
        if (n < size) {
            do {
                Variance protoVariance;
                Variance variance;
                FirTypeParameterRef firTypeParameterRef;
                FirTypeParameterSymbol firTypeParameterSymbol;
                int it = n++;
                FirTypeParameterRef proto = declaration2.getTypeParameters().get(it);
                ConeTypeProjection actual = FirTypeUtilsKt.getConeType(typeRef).getTypeArguments()[it];
                FirTypeParameterRef $this$safeAs$iv2 = proto;
                boolean $i$f$safeAs2 = false;
                FirTypeParameterRef firTypeParameterRef2 = $this$safeAs$iv2;
                if (!(firTypeParameterRef2 instanceof FirTypeParameterRef)) {
                    firTypeParameterRef2 = null;
                }
                FirTypeParameterSymbol firTypeParameterSymbol2 = firTypeParameterSymbol = (firTypeParameterRef = firTypeParameterRef2) == null ? null : firTypeParameterRef.getSymbol();
                Variance variance2 = firTypeParameterSymbol == null ? null : (variance = (firTypeParameterRef = (FirTypeParameter)firTypeParameterSymbol.getFir()) == null ? null : ((FirTypeParameter)firTypeParameterRef).getVariance());
                if (variance == null || (protoVariance = variance) == Variance.INVARIANT || (!(actual instanceof ConeKotlinTypeProjectionIn) || protoVariance != Variance.OUT_VARIANCE) && (!(actual instanceof ConeKotlinTypeProjectionOut) || protoVariance != Variance.IN_VARIANCE)) continue;
                DiagnosticReporterKt.reportOn(reporter, typeRef.getSource(), FirErrors.INSTANCE.getCONFLICTING_PROJECTION(), FirTypeUtilsKt.getConeType(typeRef).toString(), context2);
                return;
            } while (n < size);
        }
    }
}

