/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.google.common.collect.Lists;
import java.net.ProxySelector;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.impl.cookie.DefaultCookieSpecProvider;
import org.apache.http.impl.cookie.IgnoreSpecProvider;
import org.apache.http.impl.cookie.NetscapeDraftSpecProvider;
import org.apache.http.impl.cookie.RFC6265CookieSpecProvider;
import org.apache.http.protocol.HttpContext;
import org.gradle.api.JavaVersion;
import org.gradle.api.credentials.HttpHeaderCredentials;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.specs.Spec;
import org.gradle.authentication.Authentication;
import org.gradle.authentication.http.BasicAuthentication;
import org.gradle.authentication.http.DigestAuthentication;
import org.gradle.authentication.http.HttpHeaderAuthentication;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.authentication.AllSchemesAuthentication;
import org.gradle.internal.authentication.AuthenticationInternal;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.resource.UriTextResource;
import org.gradle.internal.resource.transport.http.AlwaysRedirectRedirectStrategy;
import org.gradle.internal.resource.transport.http.HttpClientHttpHeaderCredentials;
import org.gradle.internal.resource.transport.http.HttpHeaderAuthScheme;
import org.gradle.internal.resource.transport.http.HttpHeaderSchemeFactory;
import org.gradle.internal.resource.transport.http.HttpProxySettings;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.gradle.internal.resource.transport.http.HttpTimeoutSettings;
import org.gradle.internal.resource.transport.http.SslContextFactory;
import org.gradle.internal.resource.transport.http.ntlm.NTLMCredentials;
import org.gradle.internal.resource.transport.http.ntlm.NTLMSchemeFactory;
import org.gradle.util.internal.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientConfigurer.class);
    private static final String HTTPS_PROTOCOLS = "https.protocols";
    private static final int MAX_HTTP_CONNECTIONS = 20;
    private final String[] sslProtocols = HttpClientConfigurer.determineHttpsProtocols();
    private final HttpSettings httpSettings;

    private static String[] determineHttpsProtocols() {
        String httpsProtocols = System.getProperty(HTTPS_PROTOCOLS);
        if (httpsProtocols != null) {
            return httpsProtocols.split(",");
        }
        if (JavaVersion.current().isJava8() && Jvm.current().isIbmJvm()) {
            return new String[]{"TLSv1.2"};
        }
        if (HttpClientConfigurer.jdkSupportsTLSProtocol("TLSv1.3")) {
            return new String[]{"TLSv1.2", "TLSv1.3"};
        }
        return new String[]{"TLSv1.2"};
    }

    private static boolean jdkSupportsTLSProtocol(String protocol) {
        try {
            for (String supportedProtocol : SSLContext.getDefault().getSupportedSSLParameters().getProtocols()) {
                if (!protocol.equals(supportedProtocol)) continue;
                return true;
            }
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    static Collection<String> supportedTlsVersions() {
        return Arrays.asList(HttpClientConfigurer.determineHttpsProtocols());
    }

    public HttpClientConfigurer(HttpSettings httpSettings) {
        this.httpSettings = httpSettings;
    }

    public void configure(HttpClientBuilder builder) {
        SystemDefaultCredentialsProvider credentialsProvider = new SystemDefaultCredentialsProvider();
        this.configureSslSocketConnectionFactory(builder, this.httpSettings.getSslContextFactory(), this.httpSettings.getHostnameVerifier());
        this.configureAuthSchemeRegistry(builder);
        this.configureCredentials(builder, (CredentialsProvider)credentialsProvider, this.httpSettings.getAuthenticationSettings());
        this.configureProxy(builder, (CredentialsProvider)credentialsProvider, this.httpSettings);
        this.configureUserAgent(builder);
        this.configureCookieSpecRegistry(builder);
        this.configureRequestConfig(builder);
        this.configureSocketConfig(builder);
        this.configureRedirectStrategy(builder);
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        builder.setMaxConnTotal(20);
        builder.setMaxConnPerRoute(20);
    }

    private void configureSslSocketConnectionFactory(HttpClientBuilder builder, SslContextFactory sslContextFactory, HostnameVerifier hostnameVerifier) {
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContextFactory.createSslContext(), this.sslProtocols, null, hostnameVerifier));
    }

    private void configureAuthSchemeRegistry(HttpClientBuilder builder) {
        builder.setDefaultAuthSchemeRegistry((Lookup)RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).register("Digest", (Object)new DigestSchemeFactory()).register("NTLM", (Object)new NTLMSchemeFactory()).register("Negotiate", (Object)new SPNegoSchemeFactory()).register("Kerberos", (Object)new KerberosSchemeFactory()).register("header", (Object)new HttpHeaderSchemeFactory()).build());
    }

    private void configureCredentials(HttpClientBuilder builder, CredentialsProvider credentialsProvider, Collection<Authentication> authentications) {
        if (authentications.size() > 0) {
            this.useCredentials(credentialsProvider, authentications);
            builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuth(this.getAuthScheme(authentications), this.isPreemptiveEnabled(authentications)));
        }
    }

    private AuthScheme getAuthScheme(Collection<Authentication> authentications) {
        if (authentications.size() == 1 && authentications.iterator().next() instanceof HttpHeaderAuthentication) {
            return new HttpHeaderAuthScheme();
        }
        return new BasicScheme();
    }

    private void configureProxy(HttpClientBuilder builder, CredentialsProvider credentialsProvider, HttpSettings httpSettings) {
        HttpProxySettings.HttpProxy httpProxy = httpSettings.getProxySettings().getProxy();
        HttpProxySettings.HttpProxy httpsProxy = httpSettings.getSecureProxySettings().getProxy();
        for (HttpProxySettings.HttpProxy proxy : Lists.newArrayList((Object[])new HttpProxySettings.HttpProxy[]{httpProxy, httpsProxy})) {
            if (proxy == null || proxy.credentials == null) continue;
            AllSchemesAuthentication authentication = new AllSchemesAuthentication((org.gradle.api.credentials.Credentials)proxy.credentials);
            authentication.addHost(proxy.host, proxy.port);
            this.useCredentials(credentialsProvider, Collections.singleton(authentication));
        }
        builder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
    }

    private void useCredentials(CredentialsProvider credentialsProvider, Collection<? extends Authentication> authentications) {
        for (Authentication authentication : authentications) {
            AuthenticationInternal authenticationInternal = (AuthenticationInternal)authentication;
            String scheme = this.getAuthScheme(authentication);
            org.gradle.api.credentials.Credentials credentials = authenticationInternal.getCredentials();
            Collection hostsForAuthentication = authenticationInternal.getHostsForAuthentication();
            assert (!hostsForAuthentication.isEmpty()) : "Credentials and authentication required for a HTTP repository, but no hosts were defined for the authentication?";
            for (AuthenticationInternal.HostAndPort hostAndPort : hostsForAuthentication) {
                HttpClientHttpHeaderCredentials httpCredentials;
                String host = hostAndPort.getHost();
                int port = hostAndPort.getPort();
                assert (host != null) : "HTTP credentials and authentication require a host scope to be defined as well";
                if (credentials instanceof HttpHeaderCredentials) {
                    HttpHeaderCredentials httpHeaderCredentials = (HttpHeaderCredentials)credentials;
                    httpCredentials = new HttpClientHttpHeaderCredentials(httpHeaderCredentials.getName(), httpHeaderCredentials.getValue());
                    credentialsProvider.setCredentials(new AuthScope(host, port, AuthScope.ANY_REALM, scheme), (Credentials)httpCredentials);
                    LOGGER.debug("Using {} for authenticating against '{}:{}' using {}", new Object[]{httpHeaderCredentials, host, port, scheme});
                    continue;
                }
                if (credentials instanceof PasswordCredentials) {
                    PasswordCredentials passwordCredentials = (PasswordCredentials)credentials;
                    if (authentication instanceof AllSchemesAuthentication) {
                        NTLMCredentials ntlmCredentials = new NTLMCredentials(passwordCredentials);
                        NTCredentials httpCredentials2 = new NTCredentials(ntlmCredentials.getUsername(), ntlmCredentials.getPassword(), ntlmCredentials.getWorkstation(), ntlmCredentials.getDomain());
                        credentialsProvider.setCredentials(new AuthScope(host, port, AuthScope.ANY_REALM, "NTLM"), (Credentials)httpCredentials2);
                        LOGGER.debug("Using {} and {} for authenticating against '{}:{}' using {}", new Object[]{passwordCredentials, ntlmCredentials, host, port, "NTLM"});
                    }
                    httpCredentials = new UsernamePasswordCredentials(passwordCredentials.getUsername(), passwordCredentials.getPassword());
                    credentialsProvider.setCredentials(new AuthScope(host, port, AuthScope.ANY_REALM, scheme), (Credentials)httpCredentials);
                    LOGGER.debug("Using {} for authenticating against '{}:{}' using {}", new Object[]{passwordCredentials, host, port, scheme});
                    continue;
                }
                throw new IllegalArgumentException(String.format("Credentials must be an instance of: %s or %s", PasswordCredentials.class.getCanonicalName(), HttpHeaderCredentials.class.getCanonicalName()));
            }
        }
    }

    private boolean isPreemptiveEnabled(Collection<Authentication> authentications) {
        return CollectionUtils.any(authentications, (Spec)new Spec<Authentication>(){

            public boolean isSatisfiedBy(Authentication element) {
                return element instanceof BasicAuthentication || element instanceof HttpHeaderAuthentication;
            }
        });
    }

    public void configureUserAgent(HttpClientBuilder builder) {
        builder.setUserAgent(UriTextResource.getUserAgentString());
    }

    private void configureCookieSpecRegistry(HttpClientBuilder builder) {
        PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.getDefault();
        builder.setPublicSuffixMatcher(publicSuffixMatcher);
        DefaultCookieSpecProvider defaultProvider = new DefaultCookieSpecProvider(DefaultCookieSpecProvider.CompatibilityLevel.DEFAULT, publicSuffixMatcher, new String[]{"EEE, dd-MMM-yy HH:mm:ss z", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd MMM yyyy HH:mm:ss zzz"}, false);
        RFC6265CookieSpecProvider laxStandardProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.RELAXED, publicSuffixMatcher);
        RFC6265CookieSpecProvider strictStandardProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.STRICT, publicSuffixMatcher);
        builder.setDefaultCookieSpecRegistry((Lookup)RegistryBuilder.create().register("default", (Object)defaultProvider).register("best-match", (Object)defaultProvider).register("compatibility", (Object)defaultProvider).register("standard", (Object)laxStandardProvider).register("standard-strict", (Object)strictStandardProvider).register("netscape", (Object)new NetscapeDraftSpecProvider()).register("ignoreCookies", (Object)new IgnoreSpecProvider()).build());
    }

    private void configureRequestConfig(HttpClientBuilder builder) {
        HttpTimeoutSettings timeoutSettings = this.httpSettings.getTimeoutSettings();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeoutSettings.getConnectionTimeoutMs()).setSocketTimeout(timeoutSettings.getSocketTimeoutMs()).build();
        builder.setDefaultRequestConfig(config);
    }

    private void configureSocketConfig(HttpClientBuilder builder) {
        HttpTimeoutSettings timeoutSettings = this.httpSettings.getTimeoutSettings();
        builder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(timeoutSettings.getSocketTimeoutMs()).setSoKeepAlive(true).build());
    }

    private void configureRedirectStrategy(HttpClientBuilder builder) {
        if (this.httpSettings.isFollowRedirects()) {
            builder.setRedirectStrategy((RedirectStrategy)new DowngradeProtectingRedirectStrategy());
        } else {
            builder.disableRedirectHandling();
        }
    }

    private String getAuthScheme(Authentication authentication) {
        if (authentication instanceof BasicAuthentication) {
            return "Basic";
        }
        if (authentication instanceof DigestAuthentication) {
            return "Digest";
        }
        if (authentication instanceof HttpHeaderAuthentication) {
            return "header";
        }
        if (authentication instanceof AllSchemesAuthentication) {
            return AuthScope.ANY_SCHEME;
        }
        throw new IllegalArgumentException(String.format("Authentication scheme of '%s' is not supported.", authentication.getClass().getSimpleName()));
    }

    private class DowngradeProtectingRedirectStrategy
    extends AlwaysRedirectRedirectStrategy {
        private DowngradeProtectingRedirectStrategy() {
        }

        private URI getRedirectLocationURI(HttpResponse response) throws ProtocolException {
            Header locationHeader = response.getFirstHeader("location");
            if (locationHeader == null) {
                throw new ProtocolException("Received redirect response " + response.getStatusLine() + " but no location header");
            }
            String location = locationHeader.getValue();
            return this.createLocationURI(location);
        }

        @Override
        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            HttpClientConfigurer.this.httpSettings.getRedirectVerifier().validateRedirects(Collections.singletonList(this.getRedirectLocationURI(response)));
            return super.getRedirect(request, response, context);
        }
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        private final AuthScheme authScheme;
        private final boolean alwaysSendAuth;

        PreemptiveAuth(AuthScheme authScheme, boolean alwaysSendAuth) {
            this.authScheme = authScheme;
            this.alwaysSendAuth = alwaysSendAuth;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException {
            HttpHost targetHost;
            CredentialsProvider credentialsProvider;
            Credentials credentials;
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() != null || authState.hasAuthOptions()) {
                return;
            }
            String requestMethod = request.getRequestLine().getMethod();
            if ((this.alwaysSendAuth || requestMethod.equals("PUT") || requestMethod.equals("POST")) && (credentials = (credentialsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider")).getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()))) != null) {
                authState.update(this.authScheme, credentials);
            }
        }
    }
}

