/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.js.naming.EncodeSignatureKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.SignatureUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"escape", "", "s", "generateSignature", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "js.translator"})
public final class SignatureUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String generateSignature(@NotNull DeclarationDescriptor descriptor2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2)) {
            return null;
        }
        if (descriptor2 instanceof DeclarationDescriptorWithVisibility && Intrinsics.areEqual((Object)((DeclarationDescriptorWithVisibility)descriptor2).getVisibility(), (Object)DescriptorVisibilities.PRIVATE) && !AnnotationsUtils.isNativeObject(descriptor2) && !AnnotationsUtils.isLibraryObject(descriptor2)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof CallableDescriptor) {
            if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary()) {
                ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)descriptor2).getConstructedClass();
                Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"descriptor.constructedClass");
                return SignatureUtilsKt.generateSignature(classDescriptor2);
            }
            Object object = ((CallableDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.containingDeclaration");
            String string3 = SignatureUtilsKt.generateSignature((DeclarationDescriptor)object);
            if (string3 == null) {
                return null;
            }
            String parent2 = string3;
            if (!(descriptor2 instanceof VariableAccessorDescriptor) && !(descriptor2 instanceof ConstructorDescriptor) && ((CallableDescriptor)descriptor2).getName().isSpecial()) {
                return null;
            }
            String separator = descriptor2 instanceof FunctionDescriptor ? "#" : "!";
            StringBuilder stringBuilder2 = new StringBuilder().append(parent2).append(separator);
            object = ((CallableDescriptor)descriptor2).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.name.asString()");
            string2 = stringBuilder2.append(SignatureUtilsKt.escape((String)object)).append('|').append(EncodeSignatureKt.encodeSignature((CallableDescriptor)descriptor2)).toString();
        } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String separator = DescriptorUtilsKt.getModule(descriptor2).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)separator, (String)"descriptor.module.name.asString()");
            String module2 = separator;
            Object object = new String[]{module2};
            Sequence sequence2 = SequencesKt.sequenceOf((Object[])object);
            object = ((PackageFragmentDescriptor)descriptor2).getFqName().pathSegments();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.fqName.pathSegments()");
            object = (Iterable)object;
            Sequence sequence3 = sequence2;
            boolean $i$f$map = false;
            void var6_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Name name = (Name)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string4 = it.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.identifier");
                String string5 = string4;
                collection.add(string5);
            }
            collection = (List)destination$iv$iv;
            Sequence parts2 = SequencesKt.plus((Sequence)sequence3, (Iterable)collection);
            string2 = SequencesKt.joinToString$default((Sequence)parts2, (CharSequence)".", null, null, (int)0, null, (Function1)generateSignature.1.INSTANCE, (int)30, null);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = ((ClassDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor2, (String)"descriptor.containingDeclaration");
            String string6 = SignatureUtilsKt.generateSignature(declarationDescriptor2);
            if (string6 == null) {
                return null;
            }
            String parent3 = string6;
            if (((ClassDescriptor)descriptor2).getName().isSpecial()) {
                return null;
            }
            StringBuilder stringBuilder3 = new StringBuilder().append(parent3).append('$');
            string6 = ((ClassDescriptor)descriptor2).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"descriptor.name.asString()");
            string2 = stringBuilder3.append(SignatureUtilsKt.escape(string6)).toString();
        } else {
            return null;
        }
        return string2;
    }

    private static final String escape(String s) {
        StringBuilder sb = new StringBuilder();
        String string2 = s;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            char c2 = c;
            String escapedChar = (((((((((((((c2 == '\\' ? true : c2 == '\"') ? true : c2 == '.') ? true : c2 == '$') ? true : c2 == '#') ? true : c2 == '!') ? true : c2 == '<') ? true : c2 == '>') ? true : c2 == '|') ? true : c2 == '+') ? true : c2 == '-') ? true : c2 == ':') ? true : c2 == '*') ? true : c2 == '?') ? Intrinsics.stringPlus((String)"\\", (Object)Character.valueOf(c)) : String.valueOf(c);
            sb.append(escapedChar);
        }
        string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        return string2;
    }

    public static final /* synthetic */ String access$escape(String s) {
        return SignatureUtilsKt.escape(s);
    }
}

