/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmEnvironment;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.internal.ReusableAction;
import org.gradle.api.internal.artifacts.JavaEcosystemAttributesDescriber;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.DescribableAttributesSchema;
import org.gradle.api.model.ObjectFactory;

public abstract class JavaEcosystemSupport {
    private static final String DEPRECATED_JAVA_API_JARS = "java-api-jars";
    private static final String DEPRECATED_JAVA_RUNTIME_JARS = "java-runtime-jars";

    public static void configureSchema(AttributesSchema attributesSchema, ObjectFactory objectFactory) {
        JavaEcosystemSupport.configureUsage(attributesSchema, objectFactory);
        JavaEcosystemSupport.configureLibraryElements(attributesSchema, objectFactory);
        JavaEcosystemSupport.configureBundling(attributesSchema);
        JavaEcosystemSupport.configureTargetPlatform(attributesSchema);
        JavaEcosystemSupport.configureTargetEnvironment(attributesSchema);
        JavaEcosystemSupport.configureConsumerDescriptors((DescribableAttributesSchema)attributesSchema);
    }

    private static void configureConsumerDescriptors(DescribableAttributesSchema attributesSchema) {
        attributesSchema.addConsumerDescriber((AttributeDescriber)new JavaEcosystemAttributesDescriber());
    }

    public static void configureDefaultTargetPlatform(HasAttributes configuration, int majorVersion) {
        AttributeContainerInternal attributes = (AttributeContainerInternal)configuration.getAttributes();
        if (!attributes.contains(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE)) {
            attributes.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, majorVersion);
        }
    }

    private static void configureTargetPlatform(AttributesSchema attributesSchema) {
        AttributeMatchingStrategy targetPlatformSchema = attributesSchema.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE);
        targetPlatformSchema.getCompatibilityRules().ordered((Comparator)Ordering.natural());
        targetPlatformSchema.getDisambiguationRules().pickLast((Comparator)Ordering.natural());
    }

    private static void configureTargetEnvironment(AttributesSchema attributesSchema) {
        AttributeMatchingStrategy targetEnvironmentSchema = attributesSchema.attribute(TargetJvmEnvironment.TARGET_JVM_ENVIRONMENT_ATTRIBUTE);
        targetEnvironmentSchema.getCompatibilityRules().add(TargetJvmEnvironmentCompatibilityRules.class);
        targetEnvironmentSchema.getDisambiguationRules().add(TargetJvmEnvironmentDisambiguationRules.class);
    }

    private static void configureBundling(AttributesSchema attributesSchema) {
        AttributeMatchingStrategy bundlingSchema = attributesSchema.attribute(Bundling.BUNDLING_ATTRIBUTE);
        bundlingSchema.getCompatibilityRules().add(BundlingCompatibilityRules.class);
        bundlingSchema.getDisambiguationRules().add(BundlingDisambiguationRules.class);
    }

    private static void configureUsage(AttributesSchema attributesSchema, final ObjectFactory objectFactory) {
        AttributeMatchingStrategy usageSchema = attributesSchema.attribute(Usage.USAGE_ATTRIBUTE);
        usageSchema.getCompatibilityRules().add(UsageCompatibilityRules.class);
        usageSchema.getDisambiguationRules().add(UsageDisambiguationRules.class, (Action)new Action<ActionConfiguration>(){

            public void execute(ActionConfiguration actionConfiguration) {
                actionConfiguration.params(new Object[]{objectFactory.named(Usage.class, "java-api")});
                actionConfiguration.params(new Object[]{objectFactory.named(Usage.class, JavaEcosystemSupport.DEPRECATED_JAVA_API_JARS)});
                actionConfiguration.params(new Object[]{objectFactory.named(Usage.class, "java-runtime")});
                actionConfiguration.params(new Object[]{objectFactory.named(Usage.class, JavaEcosystemSupport.DEPRECATED_JAVA_RUNTIME_JARS)});
            }
        });
    }

    private static void configureLibraryElements(AttributesSchema attributesSchema, ObjectFactory objectFactory) {
        AttributeMatchingStrategy libraryElementsSchema = attributesSchema.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE);
        libraryElementsSchema.getCompatibilityRules().add(LibraryElementsCompatibilityRules.class);
        libraryElementsSchema.getDisambiguationRules().add(LibraryElementsDisambiguationRules.class, actionConfiguration -> actionConfiguration.params(new Object[]{objectFactory.named(LibraryElements.class, "jar")}));
    }

    @VisibleForTesting
    public static class BundlingDisambiguationRules
    implements AttributeDisambiguationRule<Bundling>,
    ReusableAction {
        public void execute(MultipleCandidatesDetails<Bundling> details) {
            Bundling consumerValue = (Bundling)details.getConsumerValue();
            Set candidateValues = details.getCandidateValues();
            if (candidateValues.contains(consumerValue)) {
                details.closestMatch((Object)consumerValue);
                return;
            }
            if (consumerValue == null) {
                Bundling embedded = null;
                for (Bundling candidateValue : candidateValues) {
                    if ("external".equals(candidateValue.getName())) {
                        details.closestMatch((Object)candidateValue);
                        return;
                    }
                    if (!"embedded".equals(candidateValue.getName())) continue;
                    embedded = candidateValue;
                }
                if (embedded != null) {
                    details.closestMatch(embedded);
                }
            } else {
                String consumerValueName = consumerValue.getName();
                if ("external".equals(consumerValueName)) {
                    for (Bundling candidateValue : candidateValues) {
                        if (!"embedded".equals(candidateValue.getName())) continue;
                        details.closestMatch((Object)candidateValue);
                        return;
                    }
                }
            }
        }
    }

    @VisibleForTesting
    public static class BundlingCompatibilityRules
    implements AttributeCompatibilityRule<Bundling>,
    ReusableAction {
        private static final Set<String> COMPATIBLE_WITH_EXTERNAL = ImmutableSet.of((Object)"embedded", (Object)"shadowed");

        public void execute(CompatibilityCheckDetails<Bundling> details) {
            Bundling consumerValue = (Bundling)details.getConsumerValue();
            Bundling producerValue = (Bundling)details.getProducerValue();
            if (consumerValue == null) {
                details.compatible();
                return;
            }
            String consumerValueName = consumerValue.getName();
            String producerValueName = producerValue.getName();
            if ("external".equals(consumerValueName)) {
                if (COMPATIBLE_WITH_EXTERNAL.contains(producerValueName)) {
                    details.compatible();
                }
            } else if ("embedded".equals(consumerValueName) && "shadowed".equals(producerValueName)) {
                details.compatible();
            }
        }
    }

    public static class TargetJvmEnvironmentDisambiguationRules
    implements AttributeDisambiguationRule<TargetJvmEnvironment>,
    ReusableAction {
        public void execute(MultipleCandidatesDetails<TargetJvmEnvironment> details) {
            TargetJvmEnvironment consumerValue = (TargetJvmEnvironment)details.getConsumerValue();
            if (consumerValue != null && details.getCandidateValues().contains(consumerValue)) {
                details.closestMatch((Object)consumerValue);
            } else {
                Optional<TargetJvmEnvironment> standardJvm = details.getCandidateValues().stream().filter(c -> "standard-jvm".equals(c.getName())).findFirst();
                standardJvm.ifPresent(arg_0 -> details.closestMatch(arg_0));
            }
        }
    }

    public static class TargetJvmEnvironmentCompatibilityRules
    implements AttributeCompatibilityRule<TargetJvmEnvironment>,
    ReusableAction {
        public void execute(CompatibilityCheckDetails<TargetJvmEnvironment> details) {
            details.compatible();
        }
    }

    @VisibleForTesting
    public static class LibraryElementsCompatibilityRules
    implements AttributeCompatibilityRule<LibraryElements>,
    ReusableAction {
        public void execute(CompatibilityCheckDetails<LibraryElements> details) {
            LibraryElements consumerValue = (LibraryElements)details.getConsumerValue();
            LibraryElements producerValue = (LibraryElements)details.getProducerValue();
            if (consumerValue == null) {
                details.compatible();
                return;
            }
            String consumerValueName = consumerValue.getName();
            String producerValueName = producerValue.getName();
            if (("classes".equals(consumerValueName) || "resources".equals(consumerValueName) || "classes+resources".equals(consumerValueName)) && "jar".equals(producerValueName)) {
                details.compatible();
                return;
            }
        }
    }

    @VisibleForTesting
    public static class LibraryElementsDisambiguationRules
    implements AttributeDisambiguationRule<LibraryElements>,
    ReusableAction {
        final LibraryElements jar;

        @Inject
        LibraryElementsDisambiguationRules(LibraryElements jar) {
            this.jar = jar;
        }

        public void execute(MultipleCandidatesDetails<LibraryElements> details) {
            Set candidateValues = details.getCandidateValues();
            LibraryElements consumerValue = (LibraryElements)details.getConsumerValue();
            if (consumerValue == null) {
                if (candidateValues.contains(this.jar)) {
                    details.closestMatch((Object)this.jar);
                }
            } else if (candidateValues.contains(consumerValue)) {
                details.closestMatch((Object)consumerValue);
            }
        }
    }

    @VisibleForTesting
    public static class UsageCompatibilityRules
    implements AttributeCompatibilityRule<Usage>,
    ReusableAction {
        private static final Set<String> COMPATIBLE_WITH_JAVA_API = ImmutableSet.of((Object)"java-api-jars", (Object)"java-runtime-jars", (Object)"java-runtime");

        public void execute(CompatibilityCheckDetails<Usage> details) {
            String consumerValue = ((Usage)details.getConsumerValue()).getName();
            String producerValue = ((Usage)details.getProducerValue()).getName();
            if (consumerValue.equals("java-api")) {
                if (COMPATIBLE_WITH_JAVA_API.contains(producerValue)) {
                    details.compatible();
                }
                return;
            }
            if (consumerValue.equals("java-runtime") && producerValue.equals(JavaEcosystemSupport.DEPRECATED_JAVA_RUNTIME_JARS)) {
                details.compatible();
                return;
            }
        }
    }

    @VisibleForTesting
    public static class UsageDisambiguationRules
    implements AttributeDisambiguationRule<Usage>,
    ReusableAction {
        final Usage javaApi;
        final Usage javaRuntime;
        final Usage javaApiJars;
        final Usage javaRuntimeJars;
        final ImmutableSet<Usage> apiVariants;
        final ImmutableSet<Usage> runtimeVariants;

        @Inject
        UsageDisambiguationRules(Usage javaApi, Usage javaApiJars, Usage javaRuntime, Usage javaRuntimeJars) {
            this.javaApi = javaApi;
            this.javaApiJars = javaApiJars;
            this.apiVariants = ImmutableSet.of((Object)javaApi, (Object)javaApiJars);
            this.javaRuntime = javaRuntime;
            this.javaRuntimeJars = javaRuntimeJars;
            this.runtimeVariants = ImmutableSet.of((Object)javaRuntime, (Object)javaRuntimeJars);
        }

        public void execute(MultipleCandidatesDetails<Usage> details) {
            Set candidateValues = details.getCandidateValues();
            Usage consumerValue = (Usage)details.getConsumerValue();
            if (consumerValue == null) {
                if (candidateValues.contains(this.javaRuntimeJars)) {
                    details.closestMatch((Object)this.javaRuntimeJars);
                } else if (candidateValues.contains(this.javaRuntime)) {
                    details.closestMatch((Object)this.javaRuntime);
                }
            } else if (this.javaRuntime.equals(consumerValue)) {
                if (candidateValues.contains(this.javaRuntimeJars)) {
                    details.closestMatch((Object)this.javaRuntimeJars);
                } else if (candidateValues.contains(this.javaRuntime)) {
                    details.closestMatch((Object)this.javaRuntime);
                }
            } else if (candidateValues.contains(consumerValue)) {
                details.closestMatch((Object)consumerValue);
            } else if (this.javaApi.equals(consumerValue)) {
                if (candidateValues.contains(this.javaApiJars)) {
                    details.closestMatch((Object)this.javaApiJars);
                } else if (candidateValues.contains(this.javaRuntimeJars)) {
                    details.closestMatch((Object)this.javaRuntimeJars);
                } else if (candidateValues.contains(this.javaRuntime)) {
                    details.closestMatch((Object)this.javaRuntime);
                }
            }
        }
    }
}

