/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.DescriptorListLoadingContext;
import org.jetbrains.kotlin.com.intellij.ide.plugins.DescriptorLoadingContext;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PathBasedJdomXIncluder;
import org.jetbrains.kotlin.com.intellij.openapi.util.InvalidDataException;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.SafeJdomFactory;
import org.jetbrains.kotlin.com.intellij.serialization.SerializationException;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.JDOMException;

@ApiStatus.Internal
public final class PluginDescriptorLoader {
    @Nullable
    static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull Path file2, @NotNull String descriptorRelativePath, @Nullable Path pluginPath, @NotNull DescriptorLoadingContext context2) {
        if (file2 == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(2);
        }
        if (descriptorRelativePath == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(4);
        }
        Path descriptorFile = file2.resolve(descriptorRelativePath);
        try {
            IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(pluginPath == null ? file2 : pluginPath, descriptorFile.getParent(), context2.isBundled);
            Element element = JDOMUtil.load(descriptorFile, context2.parentContext.getXmlFactory());
            descriptor2.readExternal(element, context2.pathResolver, context2.parentContext, descriptor2);
            return descriptor2;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (IOException | SerializationException | JDOMException e) {
            if (context2.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            context2.parentContext.result.reportCannotLoad(file2, e);
        }
        catch (Throwable e) {
            if (context2.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            DescriptorListLoadingContext.LOG.warn("Cannot load " + descriptorFile, e);
        }
        return null;
    }

    @Nullable
    static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull Path file2, @NotNull String fileName, @NotNull PathBasedJdomXIncluder.PathResolver<?> pathResolver, @NotNull DescriptorLoadingContext context2, @Nullable Path pluginPath) {
        if (file2 == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(6);
        }
        if (pathResolver == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            PluginDescriptorLoader.$$$reportNull$$$0(8);
        }
        SafeJdomFactory factory2 = context2.parentContext.getXmlFactory();
        try {
            Element element;
            Path metaInf = context2.open(file2).getPath("/META-INF", new String[0]);
            try {
                element = JDOMUtil.load(metaInf.resolve(fileName), factory2);
            }
            catch (NoSuchFileException ignore) {
                return null;
            }
            IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(pluginPath == null ? file2 : pluginPath, metaInf, context2.isBundled);
            if (descriptor2.readExternal(element, pathResolver, context2.parentContext, descriptor2)) {
                descriptor2.jarFiles = Collections.singletonList(descriptor2.getPluginPath());
            }
            return descriptor2;
        }
        catch (InvalidDataException | SerializationException e) {
            if (context2.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            context2.parentContext.result.reportCannotLoad(file2, e);
        }
        catch (Throwable e) {
            if (context2.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            DescriptorListLoadingContext.LOG.info("Cannot load " + file2 + "!/META-INF/" + fileName, e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorRelativePath";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: 
            case 22: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 10: 
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginJarFiles";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesInLibUnderPluginDir";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingContext";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginDescriptorLoader";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 34: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 42: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginDescriptorLoader";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToFile";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDescriptors";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUncachedDescriptors";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathResolverForPlugin";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFullDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromDir";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromJar";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromFileOrDir";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromDirAndNormalize";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectPluginDirectoryContents";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "putMoreLikelyPluginJarsFirst";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fileNameIsLikeVersionedLibraryName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromDir";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromResource";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "urlToFile";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromProperty";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromClassPath";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "computePlatformPluginUrlAndCollectPluginUrls";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "collectPluginFilesInClassPath";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromArtifact";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadFullDescriptor";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createPathResolverForPlugin";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "loadFullDescriptor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 40: 
            case 44: 
            case 45: 
            case 47: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

