/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.ArrayList;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.internal.initialization.ScriptClassPathInitializer;
import org.gradle.composite.internal.CompositeProjectComponentArtifactMetadata;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.internal.build.BuildState;

public class CompositeBuildClassPathInitializer
implements ScriptClassPathInitializer {
    private final IncludedBuildTaskGraph includedBuildTaskGraph;
    private final BuildIdentifier currentBuild;

    public CompositeBuildClassPathInitializer(IncludedBuildTaskGraph includedBuildTaskGraph, BuildState currentBuild) {
        this.includedBuildTaskGraph = includedBuildTaskGraph;
        this.currentBuild = currentBuild.getBuildIdentifier();
    }

    public void execute(Configuration classpath) {
        ArtifactCollection artifacts = classpath.getIncoming().getArtifacts();
        boolean found = false;
        for (ResolvedArtifactResult artifactResult : artifacts.getArtifacts()) {
            ComponentArtifactIdentifier componentArtifactIdentifier = artifactResult.getId();
            found |= this.build(this.currentBuild, componentArtifactIdentifier);
        }
        if (found) {
            ArrayList taskFailures = new ArrayList();
            this.includedBuildTaskGraph.awaitTaskCompletion(taskFailures::add);
            if (!taskFailures.isEmpty()) {
                throw new MultipleBuildFailures(taskFailures);
            }
        }
    }

    public boolean build(BuildIdentifier requestingBuild, ComponentArtifactIdentifier artifact) {
        boolean found = false;
        if (artifact instanceof CompositeProjectComponentArtifactMetadata) {
            CompositeProjectComponentArtifactMetadata compositeBuildArtifact = (CompositeProjectComponentArtifactMetadata)artifact;
            BuildIdentifier targetBuild = compositeBuildArtifact.getComponentId().getBuild();
            assert (!requestingBuild.equals(targetBuild));
            Set tasks = compositeBuildArtifact.getBuildDependencies().getDependencies(null);
            for (Task task : tasks) {
                this.includedBuildTaskGraph.addTask(requestingBuild, targetBuild, task.getPath());
            }
            found = true;
        }
        return found;
    }
}

