/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaProject;
import org.gradle.plugins.ide.idea.model.ModuleDependency;
import org.gradle.plugins.ide.idea.model.SingleEntryModuleLibrary;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilder;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaCompilerOutput;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaContentRoot;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaDependency;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaDependencyScope;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaJavaLanguageSettings;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaLanguageLevel;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaModule;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaModuleDependency;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaProject;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaSingleEntryLibraryDependency;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaSourceDirectory;
import org.gradle.plugins.ide.internal.tooling.java.DefaultInstalledJdk;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleModuleVersion;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleProject;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class IdeaModelBuilder
implements ToolingModelBuilder {
    private final GradleProjectBuilder gradleProjectBuilder;
    private boolean offlineDependencyResolution;

    public IdeaModelBuilder(GradleProjectBuilder gradleProjectBuilder, ServiceRegistry services) {
        this.gradleProjectBuilder = gradleProjectBuilder;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.idea.IdeaProject");
    }

    public DefaultIdeaProject buildAll(String modelName, Project project) {
        Project root = project.getRootProject();
        this.applyIdeaPlugin(root, new ArrayList<GradleInternal>());
        DefaultGradleProject rootGradleProject = this.gradleProjectBuilder.buildAll(project);
        return this.build(root, rootGradleProject);
    }

    private void applyIdeaPlugin(Project root, List<GradleInternal> alreadyProcessed) {
        Set allProjects = root.getAllprojects();
        for (Project p : allProjects) {
            p.getPluginManager().apply(IdeaPlugin.class);
        }
        for (IncludedBuild includedBuild : root.getGradle().getIncludedBuilds()) {
            GradleInternal build;
            if (!(includedBuild instanceof IncludedBuildState) || alreadyProcessed.contains(build = ((IncludedBuildState)includedBuild).getConfiguredBuild())) continue;
            alreadyProcessed.add(build);
            this.applyIdeaPlugin((Project)build.getRootProject(), alreadyProcessed);
        }
    }

    private DefaultIdeaProject build(Project project, DefaultGradleProject rootGradleProject) {
        IdeaModel ideaModel = this.ideaPluginFor(project).getModel();
        IdeaProject projectModel = ideaModel.getProject();
        JavaVersion projectSourceLanguageLevel = this.convertIdeaLanguageLevelToJavaVersion(projectModel.getLanguageLevel());
        JavaVersion projectTargetBytecodeLevel = projectModel.getTargetBytecodeVersion();
        DefaultIdeaProject out = new DefaultIdeaProject().setName(projectModel.getName()).setJdkName(projectModel.getJdkName()).setLanguageLevel(new DefaultIdeaLanguageLevel(projectModel.getLanguageLevel().getLevel())).setJavaLanguageSettings(new DefaultIdeaJavaLanguageSettings().setSourceLanguageLevel(projectSourceLanguageLevel).setTargetBytecodeVersion(projectTargetBytecodeLevel).setJdk(DefaultInstalledJdk.current()));
        ArrayList ideaModules = Lists.newArrayList();
        for (IdeaModule module : projectModel.getModules()) {
            ideaModules.add(this.createModule(module, out, rootGradleProject));
        }
        out.setChildren(new LinkedList(ideaModules));
        return out;
    }

    private IdeaPlugin ideaPluginFor(Project project) {
        return (IdeaPlugin)project.getPlugins().getPlugin(IdeaPlugin.class);
    }

    private void buildDependencies(DefaultIdeaModule tapiModule, IdeaModule ideaModule) {
        ideaModule.setOffline(this.offlineDependencyResolution);
        Set<Dependency> resolved = ideaModule.resolveDependencies();
        LinkedList<DefaultIdeaDependency> dependencies = new LinkedList<DefaultIdeaDependency>();
        for (Dependency dependency : resolved) {
            if (dependency instanceof SingleEntryModuleLibrary) {
                SingleEntryModuleLibrary d = (SingleEntryModuleLibrary)dependency;
                DefaultIdeaSingleEntryLibraryDependency defaultDependency = new DefaultIdeaSingleEntryLibraryDependency().setFile(d.getLibraryFile()).setSource(d.getSourceFile()).setJavadoc(d.getJavadocFile()).setScope(new DefaultIdeaDependencyScope(d.getScope())).setExported(d.isExported());
                if (d.getModuleVersion() != null) {
                    defaultDependency.setGradleModuleVersion(new DefaultGradleModuleVersion(d.getModuleVersion()));
                }
                dependencies.add(defaultDependency);
                continue;
            }
            if (!(dependency instanceof ModuleDependency)) continue;
            ModuleDependency moduleDependency = (ModuleDependency)dependency;
            DefaultIdeaModuleDependency ideaModuleDependency = new DefaultIdeaModuleDependency(moduleDependency.getName()).setExported(moduleDependency.isExported()).setScope(new DefaultIdeaDependencyScope(moduleDependency.getScope()));
            dependencies.add(ideaModuleDependency);
        }
        tapiModule.setDependencies(dependencies);
    }

    private DefaultIdeaModule createModule(IdeaModule ideaModule, DefaultIdeaProject ideaProject, DefaultGradleProject rootGradleProject) {
        DefaultIdeaContentRoot contentRoot = new DefaultIdeaContentRoot().setRootDirectory(ideaModule.getContentRoot()).setSourceDirectories(this.srcDirs(ideaModule.getSourceDirs(), ideaModule.getGeneratedSourceDirs())).setTestDirectories(this.srcDirs(ideaModule.getTestSourceDirs(), ideaModule.getGeneratedSourceDirs())).setResourceDirectories(this.srcDirs(ideaModule.getResourceDirs(), ideaModule.getGeneratedSourceDirs())).setTestResourceDirectories(this.srcDirs(ideaModule.getTestResourceDirs(), ideaModule.getGeneratedSourceDirs())).setExcludeDirectories(ideaModule.getExcludeDirs());
        Project project = ideaModule.getProject();
        DefaultIdeaModule defaultIdeaModule = new DefaultIdeaModule().setName(ideaModule.getName()).setParent(ideaProject).setGradleProject(rootGradleProject.findByPath(ideaModule.getProject().getPath())).setContentRoots(Collections.singletonList(contentRoot)).setJdkName(ideaModule.getJdkName()).setCompilerOutput(new DefaultIdeaCompilerOutput().setInheritOutputDirs(ideaModule.getInheritOutputDirs() != null ? ideaModule.getInheritOutputDirs() : false).setOutputDir(ideaModule.getOutputDir()).setTestOutputDir(ideaModule.getTestOutputDir()));
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
        if (javaPluginExtension != null) {
            IdeaLanguageLevel ideaModuleLanguageLevel = ideaModule.getLanguageLevel();
            JavaVersion moduleSourceLanguageLevel = this.convertIdeaLanguageLevelToJavaVersion(ideaModuleLanguageLevel);
            JavaVersion moduleTargetBytecodeVersion = ideaModule.getTargetBytecodeVersion();
            defaultIdeaModule.setJavaLanguageSettings(new DefaultIdeaJavaLanguageSettings().setSourceLanguageLevel(moduleSourceLanguageLevel).setTargetBytecodeVersion(moduleTargetBytecodeVersion));
        }
        this.buildDependencies(defaultIdeaModule, ideaModule);
        return defaultIdeaModule;
    }

    private Set<DefaultIdeaSourceDirectory> srcDirs(Set<File> sourceDirs, Set<File> generatedSourceDirs) {
        LinkedHashSet<DefaultIdeaSourceDirectory> out = new LinkedHashSet<DefaultIdeaSourceDirectory>();
        for (File s : sourceDirs) {
            DefaultIdeaSourceDirectory sourceDirectory = new DefaultIdeaSourceDirectory().setDirectory(s);
            if (generatedSourceDirs.contains(s)) {
                sourceDirectory.setGenerated(true);
            }
            out.add(sourceDirectory);
        }
        return out;
    }

    public IdeaModelBuilder setOfflineDependencyResolution(boolean offlineDependencyResolution) {
        this.offlineDependencyResolution = offlineDependencyResolution;
        return this;
    }

    private JavaVersion convertIdeaLanguageLevelToJavaVersion(IdeaLanguageLevel ideaLanguageLevel) {
        if (ideaLanguageLevel == null) {
            return null;
        }
        String languageLevel = ideaLanguageLevel.getLevel();
        return JavaVersion.valueOf((String)languageLevel.replaceFirst("JDK", "VERSION"));
    }
}

