/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.tooling.internal.protocol.InternalPhasedAction;
import org.gradle.tooling.internal.protocol.PhasedActionResult;
import org.gradle.tooling.internal.provider.ClientProvidedPhasedAction;
import org.gradle.tooling.internal.provider.PhasedBuildActionResult;
import org.gradle.tooling.internal.provider.runner.AbstractClientProvidedBuildActionRunner;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public class ClientProvidedPhasedActionRunner
extends AbstractClientProvidedBuildActionRunner
implements BuildActionRunner {
    public BuildActionRunner.Result run(BuildAction action, BuildController buildController) {
        if (!(action instanceof ClientProvidedPhasedAction)) {
            return BuildActionRunner.Result.nothing();
        }
        GradleInternal gradle = buildController.getGradle();
        gradle.getStartParameter().setConfigureOnDemand(false);
        ClientProvidedPhasedAction clientProvidedPhasedAction = (ClientProvidedPhasedAction)action;
        PayloadSerializer payloadSerializer = this.getPayloadSerializer(gradle);
        InternalPhasedAction phasedAction = (InternalPhasedAction)payloadSerializer.deserialize(clientProvidedPhasedAction.getPhasedAction());
        return this.runClientAction(new ClientActionImpl(phasedAction, gradle, action), buildController);
    }

    private PayloadSerializer getPayloadSerializer(GradleInternal gradle) {
        return (PayloadSerializer)gradle.getServices().get(PayloadSerializer.class);
    }

    private BuildEventConsumer getBuildEventConsumer(GradleInternal gradle) {
        return (BuildEventConsumer)gradle.getServices().get(BuildEventConsumer.class);
    }

    private class ClientActionImpl
    implements AbstractClientProvidedBuildActionRunner.ClientAction {
        private final InternalPhasedAction phasedAction;
        private final GradleInternal gradle;
        private final BuildAction action;

        public ClientActionImpl(InternalPhasedAction phasedAction, GradleInternal gradle, BuildAction action) {
            this.phasedAction = phasedAction;
            this.gradle = gradle;
            this.action = action;
        }

        @Override
        public Object getProjectsEvaluatedAction() {
            return this.phasedAction.getProjectsLoadedAction();
        }

        @Override
        public Object getBuildFinishedAction() {
            return this.phasedAction.getBuildFinishedAction();
        }

        @Override
        public void collectActionResult(Object result, PhasedActionResult.Phase phase) {
            PayloadSerializer payloadSerializer = ClientProvidedPhasedActionRunner.this.getPayloadSerializer(this.gradle);
            SerializedPayload serializedResult = payloadSerializer.serialize(result);
            PhasedBuildActionResult res = new PhasedBuildActionResult(serializedResult, phase);
            ClientProvidedPhasedActionRunner.this.getBuildEventConsumer(this.gradle).dispatch((Object)res);
        }

        @Override
        public boolean isRunTasks() {
            return this.action.isRunTasks();
        }

        @Override
        public Object getResult() {
            return null;
        }
    }
}

