/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.Try;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.concurrent.GradleThread;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.resources.ProjectLeaseRegistry;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.ViewBuilder;
import org.gradle.tooling.internal.gradle.GradleBuildIdentity;
import org.gradle.tooling.internal.gradle.GradleProjectIdentity;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalActionAwareBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildControllerVersion2;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.provider.connection.ProviderBuildResult;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderLookup;

class DefaultBuildController
implements InternalBuildController,
InternalBuildControllerVersion2,
InternalActionAwareBuildController {
    private final GradleInternal gradle;
    private final BuildCancellationToken cancellationToken;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectLeaseRegistry projectLeaseRegistry;
    private final boolean parallelActions = !"false".equalsIgnoreCase(System.getProperty("org.gradle.internal.tooling.parallel"));

    public DefaultBuildController(GradleInternal gradle, BuildCancellationToken cancellationToken, BuildOperationExecutor buildOperationExecutor, ProjectLeaseRegistry projectLeaseRegistry) {
        this.gradle = gradle;
        this.cancellationToken = cancellationToken;
        this.buildOperationExecutor = buildOperationExecutor;
        this.projectLeaseRegistry = projectLeaseRegistry;
    }

    @Deprecated
    public BuildResult<?> getBuildModel() throws BuildExceptionVersion1 {
        this.assertCanQuery();
        return new ProviderBuildResult((Object)this.gradle);
    }

    @Deprecated
    public BuildResult<?> getModel(Object target, ModelIdentifier modelIdentifier) throws BuildExceptionVersion1, InternalUnsupportedModelException {
        return this.getModel(target, modelIdentifier, null);
    }

    public BuildResult<?> getModel(Object target, ModelIdentifier modelIdentifier, Object parameter) throws BuildExceptionVersion1, InternalUnsupportedModelException {
        this.assertCanQuery();
        if (this.cancellationToken.isCancellationRequested()) {
            throw new BuildCancelledException(String.format("Could not build '%s' model. Build cancelled.", modelIdentifier.getName()));
        }
        ModelTarget modelTarget = this.getTarget(target);
        ToolingModelBuilderLookup.Builder builder = this.getToolingModelBuilder(modelTarget, parameter != null, modelIdentifier);
        Object model = parameter == null ? builder.build(null) : this.getParameterizedModel(builder, parameter);
        return new ProviderBuildResult(model);
    }

    public boolean getCanQueryProjectModelInParallel(Class<?> modelType) {
        return this.projectLeaseRegistry.getAllowsParallelExecution() && this.parallelActions;
    }

    public <T> List<T> run(List<Supplier<T>> actions) {
        this.assertCanQuery();
        ArrayList<NestedAction<T>> wrappers = new ArrayList<NestedAction<T>>(actions.size());
        for (Supplier<T> supplier : actions) {
            wrappers.add(new NestedAction<T>(supplier));
        }
        if (this.parallelActions) {
            this.buildOperationExecutor.runAllWithAccessToProjectState(buildOperationQueue -> {
                for (NestedAction wrapper : wrappers) {
                    buildOperationQueue.add((BuildOperation)wrapper);
                }
            });
        } else {
            for (NestedAction nestedAction : wrappers) {
                nestedAction.run(null);
            }
        }
        ArrayList<Object> results = new ArrayList<Object>(actions.size());
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        for (NestedAction nestedAction : wrappers) {
            Try value = nestedAction.value();
            if (value.isSuccessful()) {
                results.add(value.get());
                continue;
            }
            arrayList.add((Throwable)value.getFailure().get());
        }
        if (!arrayList.isEmpty()) {
            throw new MultipleBuildOperationFailures(arrayList, null);
        }
        return results;
    }

    private Object getParameterizedModel(ToolingModelBuilderLookup.Builder builder, Object parameter) throws InternalUnsupportedModelException {
        Class expectedParameterType = builder.getParameterType();
        ViewBuilder viewBuilder = new ProtocolToModelAdapter().builder(expectedParameterType);
        Object internalParameter = viewBuilder.build(parameter);
        return builder.build(internalParameter);
    }

    private ModelTarget getTarget(Object target) {
        if (target == null) {
            return new BuildScopedModel(this.gradle);
        }
        if (target instanceof GradleProjectIdentity) {
            GradleProjectIdentity projectIdentity = (GradleProjectIdentity)target;
            GradleInternal build = this.findBuild((GradleBuildIdentity)projectIdentity);
            return new ProjectScopedModel(this.findProject(build, projectIdentity));
        }
        if (target instanceof GradleBuildIdentity) {
            GradleBuildIdentity buildIdentity = (GradleBuildIdentity)target;
            return new BuildScopedModel(this.findBuild(buildIdentity));
        }
        throw new IllegalArgumentException("Don't know how to build models for " + target);
    }

    private GradleInternal findBuild(GradleBuildIdentity buildIdentity) {
        HashSet<GradleInternal> visited = new HashSet<GradleInternal>();
        GradleInternal build = this.findBuild(this.gradle, buildIdentity, visited);
        if (build != null) {
            return build;
        }
        throw new IllegalArgumentException(buildIdentity.getRootDir() + " is not included in this build");
    }

    private GradleInternal findBuild(GradleInternal rootBuild, GradleBuildIdentity buildIdentity, Set<GradleInternal> visited) {
        if (rootBuild.getRootProject().getProjectDir().equals(buildIdentity.getRootDir())) {
            return rootBuild;
        }
        for (IncludedBuild includedBuild : rootBuild.getIncludedBuilds()) {
            GradleInternal build;
            if (!(includedBuild instanceof IncludedBuildState) || visited.contains(build = ((IncludedBuildState)includedBuild).getConfiguredBuild())) continue;
            visited.add(build);
            GradleInternal matchingBuild = this.findBuild(build, buildIdentity, visited);
            if (matchingBuild == null) continue;
            return matchingBuild;
        }
        return null;
    }

    private ProjectInternal findProject(GradleInternal build, GradleProjectIdentity projectIdentity) {
        return build.getRootProject().project(projectIdentity.getProjectPath());
    }

    private ToolingModelBuilderLookup.Builder getToolingModelBuilder(ModelTarget modelTarget, boolean parameter, ModelIdentifier modelIdentifier) {
        ToolingModelBuilderLookup modelBuilderRegistry = (ToolingModelBuilderLookup)modelTarget.targetProject.getServices().get(ToolingModelBuilderLookup.class);
        try {
            return modelTarget.locate(modelBuilderRegistry, parameter, modelIdentifier);
        }
        catch (UnknownModelException e) {
            throw (InternalUnsupportedModelException)new InternalUnsupportedModelException().initCause((Throwable)e);
        }
    }

    private void assertCanQuery() {
        if (!GradleThread.isManaged()) {
            throw new IllegalStateException("A build controller cannot be used from a thread that is not managed by Gradle.");
        }
    }

    private static class NestedAction<T>
    implements RunnableBuildOperation {
        private final Supplier<T> action;
        private Try<T> result;

        public NestedAction(Supplier<T> action) {
            this.action = action;
        }

        public void run(BuildOperationContext context) {
            try {
                T value = this.action.get();
                this.result = Try.successful(value);
            }
            catch (Throwable t) {
                this.result = Try.failure((Throwable)t);
            }
        }

        public Try<T> value() {
            return this.result;
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)"Tooling API client action");
        }
    }

    private static class BuildScopedModel
    extends ModelTarget {
        private final GradleInternal targetBuild;

        public BuildScopedModel(GradleInternal gradle) {
            super(gradle.getDefaultProject());
            this.targetBuild = gradle;
        }

        @Override
        ToolingModelBuilderLookup.Builder locate(ToolingModelBuilderLookup lookup, boolean parameter, ModelIdentifier modelIdentifier) {
            return lookup.locateForClientOperation(modelIdentifier.getName(), parameter, this.targetBuild);
        }
    }

    private static class ProjectScopedModel
    extends ModelTarget {
        public ProjectScopedModel(ProjectInternal targetProject) {
            super(targetProject);
        }

        @Override
        ToolingModelBuilderLookup.Builder locate(ToolingModelBuilderLookup lookup, boolean parameter, ModelIdentifier modelIdentifier) {
            return lookup.locateForClientOperation(modelIdentifier.getName(), parameter, this.targetProject);
        }
    }

    private static abstract class ModelTarget {
        final ProjectInternal targetProject;

        protected ModelTarget(ProjectInternal targetProject) {
            this.targetProject = targetProject;
        }

        abstract ToolingModelBuilderLookup.Builder locate(ToolingModelBuilderLookup var1, boolean var2, ModelIdentifier var3);
    }
}

