/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0018\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/PsiElementFinderByType;", "", "types", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "index", "", "depth", "(Ljava/util/Collection;II)V", "find", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "root", "visitElement", "element", "currentDepth", "checkers"})
public final class PsiElementFinderByType {
    @NotNull
    private final Collection<IElementType> types;
    private int index;
    private final int depth;

    public PsiElementFinderByType(@NotNull Collection<? extends IElementType> types2, int index2, int depth) {
        Intrinsics.checkNotNullParameter(types2, (String)"types");
        this.types = types2;
        this.index = index2;
        this.depth = depth;
    }

    @Nullable
    public final PsiElement find(@NotNull PsiElement root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        return this.visitElement(root2, 0);
    }

    @Nullable
    public final PsiElement visitElement(@NotNull PsiElement element, int currentDepth) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.types.contains(element.getNode().getElementType())) {
            if (this.index == 0) {
                return element;
            }
            object = this;
            int n = ((PsiElementFinderByType)object).index;
            ((PsiElementFinderByType)object).index = n + -1;
        }
        if (currentDepth == this.depth) {
            return null;
        }
        object = PsiUtilsKt.getAllChildren(element).iterator();
        while (object.hasNext()) {
            PsiElement children2 = (PsiElement)object.next();
            PsiElement result2 = this.visitElement(children2, currentDepth + 1);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }
}

