/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationInspectorKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationPresenter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDefaultDeclarationPresenter;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rJ\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\rR#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationInspector;", "", "presenter", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationPresenter;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationPresenter;)V", "functionDeclarations", "", "", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getFunctionDeclarations", "()Ljava/util/Map;", "otherDeclarations", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getOtherDeclarations", "collect", "", "declaration", "collectFunction", "contains", "", "checkers"})
public final class FirDeclarationInspector {
    @NotNull
    private final FirDeclarationPresenter presenter;
    @NotNull
    private final Map<String, List<FirDeclaration>> otherDeclarations;
    @NotNull
    private final Map<String, List<FirSimpleFunction>> functionDeclarations;

    public FirDeclarationInspector(@NotNull FirDeclarationPresenter presenter) {
        Intrinsics.checkNotNullParameter((Object)presenter, (String)"presenter");
        this.presenter = presenter;
        boolean bl = false;
        this.otherDeclarations = new LinkedHashMap();
        bl = false;
        this.functionDeclarations = new LinkedHashMap();
    }

    public /* synthetic */ FirDeclarationInspector(FirDeclarationPresenter firDeclarationPresenter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            firDeclarationPresenter = new FirDefaultDeclarationPresenter();
        }
        this(firDeclarationPresenter);
    }

    @NotNull
    public final Map<String, List<FirDeclaration>> getOtherDeclarations() {
        return this.otherDeclarations;
    }

    @NotNull
    public final Map<String, List<FirSimpleFunction>> getFunctionDeclarations() {
        return this.functionDeclarations;
    }

    public final void collect(@NotNull FirDeclaration declaration2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (!FirDeclarationInspectorKt.access$isCollectable(declaration2)) {
            return;
        }
        if (declaration2 instanceof FirSimpleFunction) {
            this.collectFunction((FirSimpleFunction)declaration2);
            return;
        }
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirRegularClass) {
            string2 = this.presenter.represent((FirRegularClass)declaration2);
        } else if (firDeclaration instanceof FirTypeAlias) {
            string2 = this.presenter.represent((FirTypeAlias)declaration2);
        } else if (firDeclaration instanceof FirProperty) {
            string2 = this.presenter.represent((FirProperty)declaration2);
        } else {
            return;
        }
        String key = string2;
        List value2 = this.otherDeclarations.get(key);
        if (value2 == null) {
            boolean bl = false;
            value2 = new ArrayList();
            Map<String, List<FirDeclaration>> map = this.otherDeclarations;
            boolean bl2 = false;
            map.put(key, value2);
        }
        value2.add((FirDeclaration)declaration2);
    }

    private final void collectFunction(FirSimpleFunction declaration2) {
        String key = this.presenter.represent(declaration2);
        List value2 = this.functionDeclarations.get(key);
        if (value2 == null) {
            boolean bl = false;
            value2 = new ArrayList();
            Map<String, List<FirSimpleFunction>> map = this.functionDeclarations;
            boolean bl2 = false;
            map.put(key, value2);
        }
        value2.add((FirSimpleFunction)declaration2);
    }

    public final boolean contains(@NotNull FirDeclaration declaration2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirSimpleFunction) {
            Map<String, List<FirSimpleFunction>> map = this.functionDeclarations;
            String string2 = this.presenter.represent((FirSimpleFunction)declaration2);
            boolean bl2 = false;
            Map<String, List<FirSimpleFunction>> map2 = map;
            boolean bl3 = false;
            bl = map2.containsKey(string2);
        } else if (firDeclaration instanceof FirRegularClass) {
            Map<String, List<FirDeclaration>> map = this.otherDeclarations;
            String string3 = this.presenter.represent((FirRegularClass)declaration2);
            boolean bl4 = false;
            Map<String, List<FirDeclaration>> map3 = map;
            boolean bl5 = false;
            bl = map3.containsKey(string3);
        } else if (firDeclaration instanceof FirTypeAlias) {
            Map<String, List<FirDeclaration>> map = this.otherDeclarations;
            String string4 = this.presenter.represent((FirTypeAlias)declaration2);
            boolean bl6 = false;
            Map<String, List<FirDeclaration>> map4 = map;
            boolean bl7 = false;
            bl = map4.containsKey(string4);
        } else if (firDeclaration instanceof FirProperty) {
            Map<String, List<FirDeclaration>> map = this.otherDeclarations;
            String string5 = this.presenter.represent((FirProperty)declaration2);
            boolean bl8 = false;
            Map<String, List<FirDeclaration>> map5 = map;
            boolean bl9 = false;
            bl = map5.containsKey(string5);
        } else {
            bl = false;
        }
        return bl;
    }

    public FirDeclarationInspector() {
        this(null, 1, null);
    }
}

