/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.List;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;

public class SubtypingConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance(SubtypingConstraint.class);
    private PsiType myS;
    private PsiType myT;

    public SubtypingConstraint(PsiType t, PsiType s) {
        this.myT = t;
        this.myS = s;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
        this.myS = substitutor2.substitute(this.myS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubtypingConstraint that = (SubtypingConstraint)o;
        if (this.myS != null ? !this.myS.equals(that.myS) : that.myS != null) {
            return false;
        }
        return !(this.myT != null ? !this.myT.equals(that.myT) : that.myT != null);
    }

    public int hashCode() {
        int result2 = this.myS != null ? this.myS.hashCode() : 0;
        result2 = 31 * result2 + (this.myT != null ? this.myT.hashCode() : 0);
        return result2;
    }

    @Override
    public boolean reduce(InferenceSession session2, List<? super ConstraintFormula> constraints) {
        boolean reduceResult = this.doReduce(constraints);
        if (!reduceResult) {
            session2.registerIncompatibleErrorMessage(session2.getInferenceVariables(), session2.getPresentableText(this.myS) + " can be converted to " + session2.getPresentableText(this.myT));
        }
        return reduceResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doReduce(List<? super ConstraintFormula> constraints) {
        if (this.myT instanceof PsiWildcardType) {
            PsiType tBound = ((PsiWildcardType)this.myT).getBound();
            if (tBound == null) {
                return true;
            }
            if (((PsiWildcardType)this.myT).isExtends()) {
                if (this.myS instanceof PsiWildcardType) {
                    PsiType sBound = ((PsiWildcardType)this.myS).getBound();
                    if (sBound == null) {
                        constraints.add(new StrictSubtypingConstraint(tBound, ((PsiWildcardType)this.myS).getExtendsBound(), false));
                        return true;
                    }
                    if (((PsiWildcardType)this.myS).isExtends()) {
                        constraints.add(new StrictSubtypingConstraint(tBound, sBound, false));
                        return true;
                    }
                    if (((PsiWildcardType)this.myS).isSuper()) {
                        constraints.add(new TypeEqualityConstraint(tBound, PsiType.getJavaLangObject(((PsiWildcardType)this.myT).getManager(), this.myT.getResolveScope())));
                        return true;
                    }
                    assert (false);
                    return false;
                }
                constraints.add(new StrictSubtypingConstraint(tBound, this.myS, false));
                return true;
            }
            LOG.assertTrue(((PsiWildcardType)this.myT).isSuper());
            if (this.myS instanceof PsiWildcardType) {
                PsiType sBound = ((PsiWildcardType)this.myS).getBound();
                if (sBound == null || !((PsiWildcardType)this.myS).isSuper()) return false;
                constraints.add(new StrictSubtypingConstraint(sBound, tBound, false));
                return true;
            }
            constraints.add(new StrictSubtypingConstraint(this.myS, tBound, false));
            return true;
        }
        if (this.myS instanceof PsiWildcardType) {
            return false;
        }
        constraints.add(new TypeEqualityConstraint(this.myT, this.myS));
        return true;
    }

    public String toString() {
        return this.myS.getPresentableText() + " <= " + this.myT.getPresentableText();
    }
}

