/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileManager;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessorResult;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.processing.IncrementalAnnotationProcessorType;
import org.gradle.api.internal.tasks.compile.processing.ElementUtils;
import org.gradle.api.internal.tasks.compile.processing.IncrementalProcessingStrategy;

class IsolatingProcessingStrategy
extends IncrementalProcessingStrategy {
    IsolatingProcessingStrategy(AnnotationProcessorResult result) {
        super(result);
        result.setType(IncrementalAnnotationProcessorType.ISOLATING);
    }

    @Override
    public void recordProcessingInputs(Set<String> supportedAnnotationTypes, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
    }

    @Override
    public void recordGeneratedType(CharSequence name, Element[] originatingElements) {
        String generatedType = name.toString();
        Set<String> originatingTypes = ElementUtils.getTopLevelTypeNames(originatingElements);
        int size = originatingTypes.size();
        if (size != 1) {
            this.result.setFullRebuildCause("the generated type '" + generatedType + "' must have exactly one originating element, but had " + size);
        }
        this.result.addGeneratedType(generatedType, originatingTypes);
    }

    @Override
    public void recordGeneratedResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element[] originatingElements) {
        GeneratedResource.Location resourceLocation = GeneratedResource.Location.from(location);
        if (resourceLocation == null) {
            this.result.setFullRebuildCause(location + " is not supported for incremental annotation processing");
            return;
        }
        GeneratedResource generatedResource = new GeneratedResource(resourceLocation, pkg, relativeName);
        Set<String> originatingTypes = ElementUtils.getTopLevelTypeNames(originatingElements);
        int size = originatingTypes.size();
        if (size != 1) {
            this.result.setFullRebuildCause("the generated resource '" + generatedResource + "' must have exactly one originating element, but had " + size);
        }
        this.result.addGeneratedResource(generatedResource, originatingTypes);
    }
}

