/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.util.HashSet;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicateFileCopyingException;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.tasks.WorkResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateHandlingCopyActionDecorator
implements CopyAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuplicateHandlingCopyActionDecorator.class);
    private final CopyAction delegate;
    private final DocumentationRegistry documentationRegistry;

    public DuplicateHandlingCopyActionDecorator(CopyAction delegate, DocumentationRegistry documentationRegistry) {
        this.delegate = delegate;
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public WorkResult execute(CopyActionProcessingStream stream) {
        HashSet visitedFiles = new HashSet();
        return this.delegate.execute(action -> stream.process(details -> {
            if (!details.isDirectory()) {
                DuplicatesStrategy strategy = details.getDuplicatesStrategy();
                RelativePath relativePath = details.getRelativePath();
                if (!visitedFiles.add(relativePath)) {
                    if (details.isDefaultDuplicatesStrategy()) {
                        this.failWithIncorrectDuplicatesStrategySetup(relativePath);
                    }
                    if (strategy == DuplicatesStrategy.EXCLUDE) {
                        return;
                    }
                    if (strategy == DuplicatesStrategy.FAIL) {
                        throw new DuplicateFileCopyingException(String.format("Encountered duplicate path \"%s\" during copy operation configured with DuplicatesStrategy.FAIL", details.getRelativePath()));
                    }
                    if (strategy == DuplicatesStrategy.WARN) {
                        LOGGER.warn("Encountered duplicate path \"{}\" during copy operation configured with DuplicatesStrategy.WARN", (Object)details.getRelativePath());
                    }
                }
            }
            action.processFile(details);
        }));
    }

    private void failWithIncorrectDuplicatesStrategySetup(RelativePath relativePath) {
        throw new InvalidUserCodeException("Entry " + relativePath.getPathString() + " is a duplicate but no duplicate handling strategy has been set. Please refer to " + this.documentationRegistry.getDslRefForProperty(CopySpec.class, "duplicatesStrategy") + " for details.");
    }
}

