/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ArchiveHandler;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandler;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.containers.FactoryMap;

class CoreJarHandler
extends ZipHandler {
    private final CoreJarFileSystem myFileSystem;
    private final VirtualFile myRoot;

    CoreJarHandler(@NotNull CoreJarFileSystem fileSystem, @NotNull String path2) {
        if (fileSystem == null) {
            CoreJarHandler.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            CoreJarHandler.$$$reportNull$$$0(1);
        }
        super(path2);
        this.myFileSystem = fileSystem;
        HashMap<ArchiveHandler.EntryInfo, CoreJarVirtualFile> entries = new HashMap<ArchiveHandler.EntryInfo, CoreJarVirtualFile>();
        Map<String, ArchiveHandler.EntryInfo> entriesMap = this.getEntriesMap();
        Map<CoreJarVirtualFile, List> childrenMap = FactoryMap.create(key -> new ArrayList());
        for (ArchiveHandler.EntryInfo info : entriesMap.values()) {
            CoreJarVirtualFile file2 = this.getOrCreateFile(info, entries);
            VirtualFile parent2 = file2.getParent();
            if (parent2 == null) continue;
            childrenMap.get(parent2).add(file2);
        }
        ArchiveHandler.EntryInfo rootInfo = this.getEntryInfo("");
        this.myRoot = rootInfo != null ? this.getOrCreateFile(rootInfo, entries) : null;
        for (Map.Entry<CoreJarVirtualFile, List> entry : childrenMap.entrySet()) {
            List childList = entry.getValue();
            entry.getKey().setChildren(childList.toArray(VirtualFile.EMPTY_ARRAY));
        }
    }

    @NotNull
    private CoreJarVirtualFile getOrCreateFile(@NotNull ArchiveHandler.EntryInfo info, @NotNull Map<ArchiveHandler.EntryInfo, CoreJarVirtualFile> entries) {
        CoreJarVirtualFile file2;
        if (info == null) {
            CoreJarHandler.$$$reportNull$$$0(2);
        }
        if (entries == null) {
            CoreJarHandler.$$$reportNull$$$0(3);
        }
        if ((file2 = entries.get(info)) == null) {
            ArchiveHandler.EntryInfo parent2 = info.parent;
            file2 = new CoreJarVirtualFile(this, info.shortName, info.isDirectory ? -1L : info.length, info.timestamp, parent2 != null ? this.getOrCreateFile(parent2, entries) : null);
            entries.put(info, file2);
        }
        CoreJarVirtualFile coreJarVirtualFile = file2;
        if (coreJarVirtualFile == null) {
            CoreJarHandler.$$$reportNull$$$0(4);
        }
        return coreJarVirtualFile;
    }

    @Nullable
    VirtualFile findFileByPath(@NotNull String pathInJar) {
        if (pathInJar == null) {
            CoreJarHandler.$$$reportNull$$$0(5);
        }
        return this.myRoot != null ? this.myRoot.findFileByRelativePath(pathInJar) : null;
    }

    @NotNull
    CoreJarFileSystem getFileSystem() {
        CoreJarFileSystem coreJarFileSystem = this.myFileSystem;
        if (coreJarFileSystem == null) {
            CoreJarHandler.$$$reportNull$$$0(6);
        }
        return coreJarFileSystem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/jar/CoreJarHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/jar/CoreJarHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateFile";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

