/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentIntObjectHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;

public class ConcurrentMultiMap<K, V>
extends MultiMap<K, V> {
    public static final int DEFAULT_CONCURRENCY_LEVEL = ConcurrentIntObjectHashMap.NCPU;

    @Override
    @NotNull
    protected ConcurrentMap<K, Collection<V>> createMap() {
        ConcurrentMap<K, Collection<V>> concurrentMap = this.createMap(16, 0.75f);
        if (concurrentMap == null) {
            ConcurrentMultiMap.$$$reportNull$$$0(0);
        }
        return concurrentMap;
    }

    @NotNull
    protected ConcurrentMap<K, Collection<V>> createMap(int initialCapacity, float loadFactor) {
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap(initialCapacity, loadFactor, DEFAULT_CONCURRENCY_LEVEL);
        if (concurrentMap == null) {
            ConcurrentMultiMap.$$$reportNull$$$0(1);
        }
        return concurrentMap;
    }

    @Override
    @NotNull
    protected Collection<V> createCollection() {
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        if (list2 == null) {
            ConcurrentMultiMap.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    public void putValue(@NotNull K key, V value2) {
        Collection<V> collection;
        if (key == null) {
            ConcurrentMultiMap.$$$reportNull$$$0(3);
        }
        if ((collection = (Collection<V>)this.myMap.get(key)) == null) {
            Collection<V> newCollection = this.createCollection();
            collection = ConcurrencyUtil.cacheOrGet((ConcurrentMap)this.myMap, key, newCollection);
        }
        collection.add(value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentMultiMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentMultiMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putValue";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

