/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.io.File;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.internal.tasks.properties.OutputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.execution.plan.MutationInfo;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.resources.ResourceDeadlockException;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.service.ServiceRegistry;

public class LocalTaskNode
extends TaskNode {
    private final TaskInternal task;
    private ImmutableActionSet<Task> postAction = ImmutableActionSet.empty();
    private boolean isolated;
    private List<? extends ResourceLock> resourceLocks;

    public LocalTaskNode(TaskInternal task) {
        this.task = task;
    }

    public void isolated() {
        this.isolated = true;
    }

    @Override
    @Nullable
    public ResourceLock getProjectToLock() {
        if (this.isolated) {
            return null;
        }
        return ((ProjectInternal)this.task.getProject()).getMutationState().getAccessLock();
    }

    @Override
    @Nullable
    public ProjectInternal getOwningProject() {
        return (ProjectInternal)this.task.getProject();
    }

    @Override
    public List<? extends ResourceLock> getResourcesToLock() {
        if (this.resourceLocks == null) {
            this.resourceLocks = this.task.getSharedResources();
        }
        return this.resourceLocks;
    }

    @Override
    public TaskInternal getTask() {
        return this.task;
    }

    @Override
    public Action<? super Task> getPostAction() {
        return this.postAction;
    }

    @Override
    public void appendPostAction(Action<? super Task> action) {
        this.postAction = this.postAction.add(action);
    }

    @Override
    public Throwable getNodeFailure() {
        return this.task.getState().getFailure();
    }

    @Override
    public void rethrowNodeFailure() {
        this.task.getState().rethrowFailure();
    }

    @Override
    public void prepareForExecution() {
        ((TaskContainerInternal)this.task.getProject().getTasks()).prepareForExecution(this.task);
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
        for (Node targetNode : this.getDependencies(dependencyResolver)) {
            this.addDependencySuccessor(targetNode);
            processHardSuccessor.execute((Object)targetNode);
        }
        for (Node targetNode : this.getFinalizedBy(dependencyResolver)) {
            if (!(targetNode instanceof TaskNode)) {
                throw new IllegalStateException("Only tasks can be finalizers: " + targetNode);
            }
            this.addFinalizerNode((TaskNode)targetNode);
            processHardSuccessor.execute((Object)targetNode);
        }
        for (Node targetNode : this.getMustRunAfter(dependencyResolver)) {
            this.addMustSuccessor((TaskNode)targetNode);
        }
        for (Node targetNode : this.getShouldRunAfter(dependencyResolver)) {
            this.addShouldSuccessor(targetNode);
        }
    }

    @Override
    public boolean requiresMonitoring() {
        return false;
    }

    private void addFinalizerNode(TaskNode finalizerNode) {
        this.addFinalizer(finalizerNode);
        if (!finalizerNode.isInKnownState()) {
            finalizerNode.mustNotRun();
        }
    }

    private Set<Node> getDependencies(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getTaskDependencies());
    }

    private Set<Node> getFinalizedBy(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getFinalizedBy());
    }

    private Set<Node> getMustRunAfter(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getMustRunAfter());
    }

    private Set<Node> getShouldRunAfter(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getShouldRunAfter());
    }

    @Override
    public int compareTo(Node other) {
        if (this.getClass() != other.getClass()) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        LocalTaskNode localTask = (LocalTaskNode)other;
        return this.task.compareTo(localTask.task);
    }

    @Override
    public String toString() {
        return this.task.getIdentityPath().toString();
    }

    @Override
    public void resolveMutations() {
        final LocalTaskNode taskNode = this;
        final TaskInternal task = this.getTask();
        final MutationInfo mutations = this.getMutationInfo();
        ProjectInternal project = (ProjectInternal)task.getProject();
        ServiceRegistry serviceRegistry = project.getServices();
        final FileCollectionFactory fileCollectionFactory = (FileCollectionFactory)serviceRegistry.get(FileCollectionFactory.class);
        PropertyWalker propertyWalker = (PropertyWalker)serviceRegistry.get(PropertyWalker.class);
        try {
            TaskPropertyUtils.visitProperties(propertyWalker, task, new PropertyVisitor.Adapter(){

                @Override
                public void visitOutputFileProperty(String propertyName, boolean optional, PropertyValue value, OutputFilePropertyType filePropertyType) {
                    LocalTaskNode.this.withDeadlockHandling(taskNode, "an output", "output property '" + propertyName + "'", () -> FileParameterUtils.resolveOutputFilePropertySpecs(task.toString(), propertyName, value, filePropertyType, fileCollectionFactory, true, outputFilePropertySpec -> {
                        File outputLocation = outputFilePropertySpec.getOutputFile();
                        if (outputLocation != null) {
                            mutations2.outputPaths.add(outputLocation.getAbsolutePath());
                        }
                    }));
                    mutations.hasOutputs = true;
                }

                @Override
                public void visitLocalStateProperty(Object value) {
                    LocalTaskNode.this.withDeadlockHandling(taskNode, "a local state", "local state properties", () -> fileCollectionFactory.resolving(value).forEach(file -> mutations2.outputPaths.add(file.getAbsolutePath())));
                    mutations.hasLocalState = true;
                }

                @Override
                public void visitDestroyableProperty(Object value) {
                    LocalTaskNode.this.withDeadlockHandling(taskNode, "a destroyable", "destroyables", () -> fileCollectionFactory.resolving(value).forEach(file -> mutations2.destroyablePaths.add(file.getAbsolutePath())));
                }

                @Override
                public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, DirectorySensitivity directorySensitivity, boolean incremental, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
                    mutations.hasFileInputs = true;
                }
            });
        }
        catch (Exception e) {
            throw new TaskExecutionException(task, e);
        }
        mutations.resolved = true;
        if (!mutations.destroyablePaths.isEmpty()) {
            if (mutations.hasOutputs) {
                throw new IllegalStateException("Task " + taskNode + " has both outputs and destroyables defined.  A task can define either outputs or destroyables, but not both.");
            }
            if (mutations.hasFileInputs) {
                throw new IllegalStateException("Task " + taskNode + " has both inputs and destroyables defined.  A task can define either inputs or destroyables, but not both.");
            }
            if (mutations.hasLocalState) {
                throw new IllegalStateException("Task " + taskNode + " has both local state and destroyables defined.  A task can define either local state or destroyables, but not both.");
            }
        }
    }

    private void withDeadlockHandling(TaskNode task, String singular, String description, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (ResourceDeadlockException e) {
            throw new IllegalStateException(String.format("A deadlock was detected while resolving the %s for task '%s'. This can be caused, for instance, by %s property causing dependency resolution.", description, task, singular), e);
        }
    }
}

