/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.pico;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.kotlin.org.picocontainer.Parameter;
import org.jetbrains.kotlin.org.picocontainer.PicoRegistrationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.AbstractComponentAdapter;
import org.jetbrains.kotlin.org.picocontainer.defaults.ComponentParameter;

abstract class InstantiatingComponentAdapter
extends AbstractComponentAdapter {
    protected transient Parameter[] parameters;
    protected boolean allowNonPublicClasses;

    protected InstantiatingComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters2, boolean allowNonPublicClasses) {
        super(componentKey, componentImplementation);
        this.checkConcrete();
        if (parameters2 != null) {
            for (int i = 0; i < parameters2.length; ++i) {
                if (parameters2[i] != null) continue;
                throw new NullPointerException("Parameter " + i + " is null");
            }
        }
        this.parameters = parameters2;
        this.allowNonPublicClasses = allowNonPublicClasses;
    }

    private void checkConcrete() {
        boolean isAbstract;
        Class<?> componentImplementation = this.getComponentImplementation();
        boolean bl = isAbstract = (componentImplementation.getModifiers() & 0x400) == 1024;
        if (componentImplementation.isInterface() || isAbstract) {
            throw new PicoRegistrationException("Bad Access: '" + componentImplementation.getName() + "' is not instantiable");
        }
    }

    protected Parameter[] createDefaultParameters(Class<?>[] parameters2) {
        Parameter[] componentParameters = new Parameter[parameters2.length];
        for (int i = 0; i < parameters2.length; ++i) {
            componentParameters[i] = ComponentParameter.DEFAULT;
        }
        return componentParameters;
    }

    protected Object newInstance(Constructor<?> constructor2, Object[] parameters2) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.allowNonPublicClasses) {
            constructor2.setAccessible(true);
        }
        return constructor2.newInstance(parameters2);
    }
}

