/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.diagnostic;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.Activity;
import org.jetbrains.kotlin.com.intellij.diagnostic.ActivityCategory;
import org.jetbrains.kotlin.com.intellij.diagnostic.ActivityImpl;
import org.jetbrains.kotlin.com.intellij.diagnostic.LoadingState;

public final class StartUpMeasurer {
    static final AtomicReference<LoadingState> currentState = new AtomicReference<LoadingState>(LoadingState.BOOTSTRAP);
    public static final long MEASURE_THRESHOLD = TimeUnit.MILLISECONDS.toNanos(10L);
    public static boolean measuringPluginStartupCosts = true;
    private static long startTime = System.nanoTime();
    private static final ConcurrentLinkedQueue<ActivityImpl> items = new ConcurrentLinkedQueue();
    private static boolean isEnabled = true;
    @ApiStatus.Internal
    public static final Map<String, Object<String>> pluginCostMap = new HashMap<String, Object<String>>();

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static long getCurrentTime() {
        return System.nanoTime();
    }

    @NotNull
    public static Activity startActivity(@NotNull String name) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(1);
        }
        return StartUpMeasurer.startActivity(name, ActivityCategory.APP_INIT);
    }

    @NotNull
    public static Activity startActivity(@NotNull String name, @NotNull ActivityCategory category) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(2);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(3);
        }
        return StartUpMeasurer.startActivity(name, category, null);
    }

    @NotNull
    public static Activity startActivity(@NotNull String name, @NotNull ActivityCategory category, @Nullable String pluginId) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(4);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(5);
        }
        return new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), null, pluginId, category);
    }

    /*
     * WARNING - void declaration
     */
    public static long addCompletedActivity(long start, @NotNull Class<?> clazz, @NotNull ActivityCategory category, @Nullable String pluginId, long l) {
        void threshold;
        if (clazz == null) {
            StartUpMeasurer.$$$reportNull$$$0(9);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(10);
        }
        if (!isEnabled) {
            return -1L;
        }
        long end = StartUpMeasurer.getCurrentTime();
        long duration = end - start;
        if (duration <= threshold) {
            return duration;
        }
        StartUpMeasurer.addCompletedActivity(start, end, clazz.getName(), category, pluginId);
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    public static void addCompletedActivity(long start, long end, @NotNull String name, @NotNull ActivityCategory activityCategory, String string2) {
        void category;
        void pluginId;
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(13);
        }
        if (activityCategory == null) {
            StartUpMeasurer.$$$reportNull$$$0(14);
        }
        if (!isEnabled) {
            return;
        }
        ActivityImpl item = new ActivityImpl(name, start, null, (String)pluginId, (ActivityCategory)category);
        item.setEnd(end);
        StartUpMeasurer.addActivity(item);
    }

    @ApiStatus.Internal
    public static long getStartTime() {
        return startTime;
    }

    static void addActivity(@NotNull ActivityImpl activity) {
        if (activity == null) {
            StartUpMeasurer.$$$reportNull$$$0(20);
        }
        items.add(activity);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedState";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timings";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginCostMap";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/diagnostic/StartUpMeasurer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addInstantEvent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startActivity";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "startMainActivity";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletedActivity";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrentState";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "compareAndSetCurrentState";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "stateSet";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "processAndClear";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "addActivity";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "addTimings";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "addPluginCost";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "doAddPluginCost";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

