/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Optional;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.AfterPreviousExecutionContext;
import org.gradle.internal.execution.CachingResult;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;

public class SkipEmptyWorkStep<C extends AfterPreviousExecutionContext>
implements Step<C, CachingResult> {
    private final Step<? super C, ? extends CachingResult> delegate;

    public SkipEmptyWorkStep(Step<? super C, ? extends CachingResult> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CachingResult execute(C context) {
        UnitOfWork work = context.getWork();
        ImmutableSortedMap outputFilesAfterPreviousExecution = context.getAfterPreviousExecutionState().map(AfterPreviousExecutionState::getOutputFileProperties).orElse(ImmutableSortedMap.of());
        return work.skipIfInputsEmpty((ImmutableSortedMap<String, FileCollectionFingerprint>)outputFilesAfterPreviousExecution).map(skippedOutcome -> {
            work.getExecutionHistoryStore().ifPresent(executionHistoryStore -> executionHistoryStore.remove(work.getIdentity()));
            return new CachingResult((ExecutionOutcome)((Object)skippedOutcome)){
                final /* synthetic */ ExecutionOutcome val$skippedOutcome;
                {
                    this.val$skippedOutcome = executionOutcome;
                }

                @Override
                public Try<ExecutionOutcome> getOutcome() {
                    return Try.successful((Object)((Object)this.val$skippedOutcome));
                }

                @Override
                public CachingState getCachingState() {
                    return CachingState.NOT_DETERMINED;
                }

                @Override
                public ImmutableList<String> getExecutionReasons() {
                    return ImmutableList.of();
                }

                @Override
                public ImmutableSortedMap<String, ? extends FileCollectionFingerprint> getFinalOutputs() {
                    return ImmutableSortedMap.of();
                }

                @Override
                public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                    return Optional.empty();
                }
            };
        }).orElseGet(() -> this.delegate.execute((AfterPreviousExecutionContext)context));
    }
}

