/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.tasks;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.gradle.testing.jacoco.tasks.JacocoBase;

public abstract class JacocoReportBase
extends JacocoBase {
    private final ConfigurableFileCollection executionData = this.getProject().files(new Object[0]);
    private final ConfigurableFileCollection sourceDirectories = this.getProject().files(new Object[0]);
    private final ConfigurableFileCollection classDirectories = this.getProject().files(new Object[0]);
    private final ConfigurableFileCollection additionalClassDirs = this.getProject().files(new Object[0]);
    private final ConfigurableFileCollection additionalSourceDirs = this.getProject().files(new Object[0]);

    public JacocoReportBase() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return Iterables.any((Iterable)JacocoReportBase.this.getExecutionData(), (Predicate)new Predicate<File>(){

                    public boolean apply(File file) {
                        return file.exists();
                    }
                });
            }
        });
    }

    @Inject
    protected Instantiator getInstantiator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected CollectionCallbackActionDecorator getCallbackActionDecorator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected IsolatedAntBuilder getAntBuilder() {
        throw new UnsupportedOperationException();
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFiles
    public ConfigurableFileCollection getExecutionData() {
        return this.executionData;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public ConfigurableFileCollection getSourceDirectories() {
        return this.sourceDirectories;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public ConfigurableFileCollection getClassDirectories() {
        return this.classDirectories;
    }

    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public ConfigurableFileCollection getAdditionalClassDirs() {
        return this.additionalClassDirs;
    }

    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public ConfigurableFileCollection getAdditionalSourceDirs() {
        return this.additionalSourceDirs;
    }

    public void executionData(Object ... files) {
        this.executionData.from(files);
    }

    public void executionData(Task ... tasks) {
        for (Task task : tasks) {
            final JacocoTaskExtension extension = (JacocoTaskExtension)task.getExtensions().findByType(JacocoTaskExtension.class);
            if (extension == null) continue;
            this.executionData(new Callable<File>(){

                @Override
                public File call() {
                    return extension.getDestinationFile();
                }
            });
            this.mustRunAfter(new Object[]{task});
        }
    }

    public void executionData(TaskCollection tasks) {
        tasks.all(xva$0 -> this.executionData((Task)xva$0));
    }

    @Internal
    public FileCollection getAllClassDirs() {
        return this.classDirectories.plus((FileCollection)this.getAdditionalClassDirs());
    }

    @Internal
    public FileCollection getAllSourceDirs() {
        return this.sourceDirectories.plus((FileCollection)this.getAdditionalSourceDirs());
    }

    public void sourceSets(SourceSet ... sourceSets) {
        for (final SourceSet sourceSet : sourceSets) {
            this.sourceDirectories.from(new Object[]{new Callable<Set<File>>(){

                @Override
                public Set<File> call() throws Exception {
                    return sourceSet.getAllJava().getSrcDirs();
                }
            }});
            this.classDirectories.from(new Object[]{sourceSet.getOutput()});
        }
    }

    public void additionalClassDirs(File ... dirs) {
        this.additionalClassDirs((FileCollection)this.getProject().files(new Object[]{Arrays.asList(dirs)}));
    }

    public void additionalClassDirs(FileCollection dirs) {
        this.additionalClassDirs.from(new Object[]{dirs});
    }

    public void additionalSourceDirs(File ... dirs) {
        this.additionalSourceDirs((FileCollection)this.getProject().files(new Object[]{Arrays.asList(dirs)}));
    }

    public void additionalSourceDirs(FileCollection dirs) {
        this.additionalSourceDirs.from(new Object[]{dirs});
    }
}

