/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.vfs.impl;

import java.io.File;
import org.gradle.internal.vfs.impl.AbstractVirtualFileSystem;
import org.gradle.internal.watch.vfs.WatchingAwareVirtualFileSystem;
import org.gradle.internal.watch.vfs.impl.AbstractDelegatingVirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonWatchingVirtualFileSystem
extends AbstractDelegatingVirtualFileSystem
implements WatchingAwareVirtualFileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonWatchingVirtualFileSystem.class);

    public NonWatchingVirtualFileSystem(AbstractVirtualFileSystem delegate) {
        super(delegate);
    }

    @Override
    public void afterBuildStarted(boolean watchingEnabled) {
        if (watchingEnabled) {
            LOGGER.warn("Watching for file changes is not supported on the current operating system");
        }
        this.invalidateAll();
    }

    @Override
    public void updateProjectRootDirectory(File projectRootDirectory) {
    }

    @Override
    public void beforeBuildFinished(boolean watchingEnabled) {
        this.invalidateAll();
    }
}

