/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u0001*\u0006\u0012\u0002\b\u00030\u0002\u001a\u0014\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0001*\u0006\u0012\u0002\b\u00030\u0004H\u0002\u00a8\u0006\u0005"}, d2={"getIrConstKind", "Lorg/jetbrains/kotlin/ir/expressions/IrConstKind;", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "toIrConstKind", "Lorg/jetbrains/kotlin/fir/expressions/FirConstKind;", "tree"})
public final class FirConstKindKt {
    @NotNull
    public static final IrConstKind<?> getIrConstKind(@NotNull FirConstExpression<?> $this$getIrConstKind) {
        IrConstKind<?> irConstKind;
        Intrinsics.checkParameterIsNotNull($this$getIrConstKind, (String)"$this$getIrConstKind");
        FirConstKind<?> firConstKind = $this$getIrConstKind.getKind();
        if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.IntegerLiteral.INSTANCE)) {
            FirTypeRef $this$coneTypeUnsafe$iv = $this$getIrConstKind.getTypeRef();
            boolean $i$f$coneTypeUnsafe = false;
            FirTypeRef firTypeRef = $this$coneTypeUnsafe$iv;
            if (firTypeRef == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
            }
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)firTypeRef).getType();
            if (coneKotlinType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType");
            }
            ConeIntegerLiteralType type2 = (ConeIntegerLiteralType)((ConeKotlinType)((ConeIntegerLiteralType)coneKotlinType));
            FirConstKind<?> firConstKind2 = FirTypeUtilsKt.toConstKind(ConeIntegerLiteralType.getApproximatedType$default(type2, null, 1, null));
            if (firConstKind2 == null) {
                Intrinsics.throwNpe();
            }
            irConstKind = FirConstKindKt.toIrConstKind(firConstKind2);
        } else {
            irConstKind = FirConstKindKt.toIrConstKind($this$getIrConstKind.getKind());
        }
        return irConstKind;
    }

    private static final IrConstKind<?> toIrConstKind(@NotNull FirConstKind<?> $this$toIrConstKind) {
        IrConstKind irConstKind;
        FirConstKind<?> firConstKind = $this$toIrConstKind;
        if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Null.INSTANCE)) {
            irConstKind = IrConstKind.Null.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Boolean.INSTANCE)) {
            irConstKind = IrConstKind.Boolean.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Char.INSTANCE)) {
            irConstKind = IrConstKind.Char.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Byte.INSTANCE)) {
            irConstKind = IrConstKind.Byte.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Short.INSTANCE)) {
            irConstKind = IrConstKind.Short.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Int.INSTANCE)) {
            irConstKind = IrConstKind.Int.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Long.INSTANCE)) {
            irConstKind = IrConstKind.Long.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.String.INSTANCE)) {
            irConstKind = IrConstKind.String.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Float.INSTANCE)) {
            irConstKind = IrConstKind.Float.INSTANCE;
        } else if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.Double.INSTANCE)) {
            irConstKind = IrConstKind.Double.INSTANCE;
        } else {
            if (Intrinsics.areEqual(firConstKind, (Object)FirConstKind.IntegerLiteral.INSTANCE)) {
                throw (Throwable)new IllegalArgumentException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return irConstKind;
    }
}

