/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import java.io.File;
import java.util.Collection;
import org.gradle.internal.vfs.WatchingAwareVirtualFileSystem;
import org.gradle.internal.vfs.impl.AbstractDelegatingVirtualFileSystem;
import org.gradle.internal.vfs.impl.AbstractVirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonWatchingVirtualFileSystem
extends AbstractDelegatingVirtualFileSystem
implements WatchingAwareVirtualFileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonWatchingVirtualFileSystem.class);

    public NonWatchingVirtualFileSystem(AbstractVirtualFileSystem delegate) {
        super(delegate);
    }

    @Override
    public void afterBuildStarted(boolean watchingEnabled) {
        if (watchingEnabled) {
            LOGGER.warn("Watching for file changes is not supported on the current operating system");
        }
        this.invalidateAll();
    }

    @Override
    public void updateMustWatchDirectories(Collection<File> mustWatchDirectories) {
    }

    @Override
    public void beforeBuildFinished(boolean watchingEnabled) {
        this.invalidateAll();
    }
}

