/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.watch;

import com.google.common.collect.ImmutableList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;

public class WatchRootUtil {
    public static Set<Path> resolveRootsToWatch(Set<Path> directories) {
        HashSet<Path> roots = new HashSet<Path>();
        directories.stream().sorted(Comparator.comparingInt(Path::getNameCount)).filter(path -> {
            Path parent = path;
            while ((parent = parent.getParent()) != null) {
                if (!roots.contains(parent)) continue;
                return false;
            }
            return true;
        }).forEach(roots::add);
        return roots;
    }

    public static ImmutableList<Path> getDirectoriesToWatch(CompleteFileSystemLocationSnapshot snapshot) {
        Path ancestorToWatch;
        Path path = Paths.get(snapshot.getAbsolutePath(), new String[0]);
        switch (snapshot.getType()) {
            case RegularFile: 
            case Directory: {
                ancestorToWatch = path.getParent();
                break;
            }
            case Missing: {
                ancestorToWatch = WatchRootUtil.findFirstExistingAncestor(path);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return snapshot.getType() == FileType.Directory ? ImmutableList.of((Object)ancestorToWatch, (Object)path) : ImmutableList.of((Object)ancestorToWatch);
    }

    private static Path findFirstExistingAncestor(Path path) {
        Path candidate = path;
        do {
            if ((candidate = candidate.getParent()) != null) continue;
            throw new IllegalStateException("Couldn't find existing ancestor for " + path);
        } while (!Files.isDirectory(candidate, new LinkOption[0]));
        return candidate;
    }
}

