/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal.jni;

import java.io.File;
import java.util.Collection;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.NativeIntegration;
import net.rubygrapefruit.platform.file.FileWatcher;
import net.rubygrapefruit.platform.file.FileWatcherCallback;

public class AbstractFileEventFunctions
implements NativeIntegration {
    public static String getVersion() {
        return AbstractFileEventFunctions.getVersion0();
    }

    private static native String getVersion0();

    public void invalidateLogLevelCache() {
        this.invalidateLogLevelCache0();
    }

    private native void invalidateLogLevelCache0();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NativeFileWatcher
    implements FileWatcher {
        private Object server;

        public NativeFileWatcher(Object server) {
            this.server = server;
        }

        @Override
        public void startWatching(Collection<File> paths) {
            if (this.server == null) {
                throw new IllegalStateException("Watcher already closed");
            }
            this.startWatching0(this.server, NativeFileWatcher.toAbsolutePaths(paths));
        }

        private native void startWatching0(Object var1, String[] var2);

        @Override
        public boolean stopWatching(Collection<File> paths) {
            if (this.server == null) {
                throw new IllegalStateException("Watcher already closed");
            }
            return this.stopWatching0(this.server, NativeFileWatcher.toAbsolutePaths(paths));
        }

        private native boolean stopWatching0(Object var1, String[] var2);

        private static String[] toAbsolutePaths(Collection<File> files) {
            String[] paths = new String[files.size()];
            int index = 0;
            for (File file : files) {
                paths[index++] = file.getAbsolutePath();
            }
            return paths;
        }

        @Override
        public void close() {
            if (this.server == null) {
                throw new NativeException("Closed already");
            }
            this.close0(this.server);
            this.server = null;
        }

        protected native void close0(Object var1);
    }

    protected static class NativeFileWatcherCallback {
        private final FileWatcherCallback delegate;

        public NativeFileWatcherCallback(FileWatcherCallback delegate) {
            this.delegate = delegate;
        }

        public void pathChanged(int type, String path) {
            this.delegate.pathChanged(FileWatcherCallback.Type.values()[type], path);
        }

        public void reportError(Throwable ex) {
            this.delegate.reportError(ex);
        }
    }
}

