/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.internal.jni.LinuxFileEventFunctions;
import org.gradle.internal.vfs.AbstractEventDrivenFileWatcherRegistry;
import org.gradle.internal.vfs.SnapshotHierarchy;
import org.gradle.internal.vfs.watch.FileWatcherRegistry;
import org.gradle.internal.vfs.watch.FileWatcherRegistryFactory;
import org.gradle.internal.vfs.watch.WatchRootUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxFileWatcherRegistry
extends AbstractEventDrivenFileWatcherRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinuxFileWatcherRegistry.class);

    public LinuxFileWatcherRegistry(Set<Path> watchRoots, FileWatcherRegistry.ChangeHandler handler) {
        super(watchRoots, callback -> ((LinuxFileEventFunctions)Native.get(LinuxFileEventFunctions.class)).startWatcher(callback), handler);
    }

    public static class Factory
    implements FileWatcherRegistryFactory {
        public FileWatcherRegistry startWatching(SnapshotHierarchy root, Predicate<String> watchFilter, Collection<File> mustWatchDirectories, FileWatcherRegistry.ChangeHandler handler) {
            Set<Path> directories = WatchRootUtil.resolveDirectoriesToWatch((SnapshotHierarchy)root, watchFilter, mustWatchDirectories).stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toSet());
            LOGGER.warn("Watching {} directories to track changes between builds", (Object)directories.size());
            return new LinuxFileWatcherRegistry(directories, handler);
        }
    }
}

