/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.HierarchicalMethodSignatureImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassImpl;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import org.jetbrains.kotlin.com.intellij.psi.search.searches.SuperMethodsSearch;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiCacheKey;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiSuperMethodUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.EqualityPolicy;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.LinkedHashMap;

public class PsiSuperMethodImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiSuperMethodImplUtil");
    private static final PsiCacheKey<Map<MethodSignature, HierarchicalMethodSignature>, PsiClass> SIGNATURES_FOR_CLASS_KEY = PsiCacheKey.create("SIGNATURES_FOR_CLASS_KEY", dom -> PsiSuperMethodImplUtil.buildMethodHierarchy(dom, null, PsiSubstitutor.EMPTY, true, (Set<? super PsiClass>)new THashSet(), false, dom.getResolveScope()));
    private static final PsiCacheKey<Map<Pair<String, GlobalSearchScope>, Map<MethodSignature, HierarchicalMethodSignature>>, PsiClass> SIGNATURES_BY_NAME_KEY = PsiCacheKey.create("SIGNATURES_BY_NAME_KEY", psiClass -> ConcurrentFactoryMap.createMap(pair -> PsiSuperMethodImplUtil.buildMethodHierarchy(psiClass, (String)pair.first, PsiSubstitutor.EMPTY, true, (Set<? super PsiClass>)new THashSet(), false, (GlobalSearchScope)pair.second)));

    private PsiSuperMethodImplUtil() {
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(@NotNull PsiMethod method) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(0);
        }
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(method, null);
        if (psiMethodArray == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(1);
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(@NotNull PsiMethod method, boolean checkAccess) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(2);
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, checkAccess, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                PsiSuperMethodImplUtil.$$$reportNull$$$0(3);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethodsInternal(method, null);
        if (psiMethodArray == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(4);
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] findSuperMethods(@NotNull PsiMethod method, PsiClass parentClass) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(5);
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                PsiSuperMethodImplUtil.$$$reportNull$$$0(6);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethodsInternal(method, parentClass);
        if (psiMethodArray == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(7);
        }
        return psiMethodArray;
    }

    @NotNull
    private static PsiMethod[] findSuperMethodsInternal(@NotNull PsiMethod method, PsiClass parentClass) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(8);
        }
        List<MethodSignatureBackedByPsiMethod> outputMethods = PsiSuperMethodImplUtil.findSuperMethodSignatures(method, parentClass, false);
        PsiMethod[] psiMethodArray = MethodSignatureUtil.convertMethodSignaturesToMethods(outputMethods);
        if (psiMethodArray == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(9);
        }
        return psiMethodArray;
    }

    @NotNull
    public static List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(@NotNull PsiMethod method, boolean checkAccess) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(10);
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, checkAccess, true)) {
            List<MethodSignatureBackedByPsiMethod> list2 = Collections.emptyList();
            if (list2 == null) {
                PsiSuperMethodImplUtil.$$$reportNull$$$0(11);
            }
            return list2;
        }
        List<MethodSignatureBackedByPsiMethod> list3 = PsiSuperMethodImplUtil.findSuperMethodSignatures(method, null, true);
        if (list3 == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(12);
        }
        return list3;
    }

    @NotNull
    private static List<MethodSignatureBackedByPsiMethod> findSuperMethodSignatures(@NotNull PsiMethod method, PsiClass parentClass, boolean allowStaticMethod) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(13);
        }
        ArrayList<MethodSignatureBackedByPsiMethod> arrayList = new ArrayList<MethodSignatureBackedByPsiMethod>(SuperMethodsSearch.search(method, parentClass, true, allowStaticMethod).findAll());
        if (arrayList == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static boolean canHaveSuperMethod(@NotNull PsiMethod method, boolean checkAccess, boolean allowStaticMethod) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(15);
        }
        if (method.isConstructor()) {
            return false;
        }
        if (!allowStaticMethod && method.hasModifierProperty("static")) {
            return false;
        }
        if (checkAccess && method.hasModifierProperty("private")) {
            return false;
        }
        PsiClass parentClass = method.getContainingClass();
        return parentClass != null && !"java.lang.Object".equals(parentClass.getQualifiedName());
    }

    @Nullable
    public static PsiMethod findDeepestSuperMethod(@NotNull PsiMethod method) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(16);
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return null;
        }
        return DeepestSuperMethodsSearch.search(method).findFirst();
    }

    @NotNull
    public static PsiMethod[] findDeepestSuperMethods(@NotNull PsiMethod method) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(17);
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                PsiSuperMethodImplUtil.$$$reportNull$$$0(18);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        Collection<PsiMethod> collection = DeepestSuperMethodsSearch.search(method).findAll();
        PsiMethod[] psiMethodArray = collection.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(19);
        }
        return psiMethodArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static Map<MethodSignature, HierarchicalMethodSignature> buildMethodHierarchy(@NotNull PsiClass aClass2, @Nullable String nameHint, @NotNull PsiSubstitutor substitutor2, boolean includePrivates, @NotNull Set<? super PsiClass> visited2, boolean isInRawContext, GlobalSearchScope resolveScope) {
        void var13_17;
        PsiMethod psiMethod;
        if (aClass2 == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(20);
        }
        if (substitutor2 == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(21);
        }
        if (visited2 == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(22);
        }
        ProgressManager.checkCanceled();
        LinkedHashMap<MethodSignature, HierarchicalMethodSignature> result2 = new LinkedHashMap<MethodSignature, HierarchicalMethodSignature>(new EqualityPolicy<MethodSignature>(){

            @Override
            public int getHashCode(MethodSignature object) {
                return object.hashCode();
            }

            @Override
            public boolean isEqual(MethodSignature o1, MethodSignature o2) {
                if (o1.equals(o2)) {
                    PsiMethod method1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod();
                    PsiType returnType1 = method1.getReturnType();
                    PsiMethod method2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod();
                    PsiType returnType2 = method2.getReturnType();
                    if (method1.hasModifierProperty("static") || method2.hasModifierProperty("static")) {
                        return true;
                    }
                    if (MethodSignatureUtil.isReturnTypeSubstitutable(o1, o2, returnType1, returnType2)) {
                        return true;
                    }
                    PsiClass containingClass1 = method1.getContainingClass();
                    PsiClass containingClass2 = method2.getContainingClass();
                    if (containingClass1 != null && containingClass2 != null) {
                        return containingClass1.isAnnotationType() || containingClass2.isAnnotationType();
                    }
                }
                return false;
            }
        });
        THashMap sameParameterErasureMethods = new THashMap(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        LinkedHashMap<MethodSignature, HierarchicalMethodSignatureImpl> map2 = new LinkedHashMap<MethodSignature, HierarchicalMethodSignatureImpl>(new EqualityPolicy<MethodSignature>((Map)sameParameterErasureMethods){
            final /* synthetic */ Map val$sameParameterErasureMethods;
            {
                this.val$sameParameterErasureMethods = map2;
            }

            @Override
            public int getHashCode(MethodSignature signature) {
                return MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.computeHashCode((Object)signature);
            }

            @Override
            public boolean isEqual(MethodSignature o1, MethodSignature o2) {
                boolean toCheckReturnType;
                if (!MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.equals((Object)o1, (Object)o2)) {
                    return false;
                }
                List list2 = (List)this.val$sameParameterErasureMethods.get(o1);
                boolean bl = toCheckReturnType = list2 != null && list2.size() > 1;
                if (!toCheckReturnType) {
                    return true;
                }
                PsiType returnType1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod().getReturnType();
                PsiType returnType2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod().getReturnType();
                if (returnType1 == null && returnType2 == null) {
                    return true;
                }
                if (returnType1 == null || returnType2 == null) {
                    return false;
                }
                PsiType erasure1 = TypeConversionUtil.erasure(o1.getSubstitutor().substitute(returnType1));
                PsiType erasure2 = TypeConversionUtil.erasure(o2.getSubstitutor().substitute(returnType2));
                return erasure1.equals(erasure2);
            }
        });
        PsiMethod[] methods2 = aClass2.getMethods();
        if ((nameHint == null || "values".equals(nameHint)) && aClass2 instanceof PsiClassImpl && (psiMethod = ((PsiClassImpl)aClass2).getValuesMethod()) != null) {
            methods2 = ArrayUtil.append(methods2, psiMethod);
        }
        PsiMethod[] psiMethodArray = methods2;
        int n = psiMethodArray.length;
        boolean bl = false;
        while (var13_17 < n) {
            PsiMethod method = psiMethodArray[var13_17];
            if (!method.isValid()) {
                throw new PsiInvalidElementAccessException((PsiElement)method, "class.valid=" + aClass2.isValid() + "; name=" + method.getName());
            }
            if (!(nameHint != null && !nameHint.equals(method.getName()) || !includePrivates && method.hasModifierProperty("private"))) {
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create(method, PsiSubstitutor.EMPTY, isInRawContext);
                HierarchicalMethodSignatureImpl newH = new HierarchicalMethodSignatureImpl(MethodSignatureBackedByPsiMethod.create(method, substitutor2, isInRawContext));
                SmartList<PsiMethod> list2 = (SmartList<PsiMethod>)sameParameterErasureMethods.get(signature);
                if (list2 == null) {
                    list2 = new SmartList<PsiMethod>();
                    sameParameterErasureMethods.put(signature, list2);
                }
                list2.add(method);
                LOG.assertTrue(newH.getMethod().isValid());
                result2.put(signature, newH);
                map2.put(signature, newH);
            }
            ++var13_17;
        }
        List<PsiClassType.ClassResolveResult> list2 = PsiClassImplUtil.getScopeCorrectedSuperTypes(aClass2, resolveScope);
        for (PsiClassType.ClassResolveResult classResolveResult : list2) {
            PsiClass superClass = classResolveResult.getElement();
            if (superClass == null || !visited2.add(superClass)) continue;
            PsiSubstitutor superSubstitutor = classResolveResult.getSubstitutor();
            PsiSubstitutor finalSubstitutor = PsiSuperMethodUtil.obtainFinalSubstitutor(superClass, superSubstitutor, substitutor2, isInRawContext);
            boolean isInRawContextSuper = (isInRawContext || PsiUtil.isRawSubstitutor(superClass, superSubstitutor)) && superClass.getTypeParameters().length != 0;
            Map<MethodSignature, HierarchicalMethodSignature> superResult = PsiSuperMethodImplUtil.buildMethodHierarchy(superClass, nameHint, finalSubstitutor, false, visited2, isInRawContextSuper, resolveScope);
            visited2.remove(superClass);
            ArrayList<Pair<MethodSignatureBackedByPsiMethod, HierarchicalMethodSignature>> flattened = new ArrayList<Pair<MethodSignatureBackedByPsiMethod, HierarchicalMethodSignature>>();
            for (Map.Entry<MethodSignature, HierarchicalMethodSignature> entry : superResult.entrySet()) {
                HierarchicalMethodSignature hms = entry.getValue();
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create(hms.getMethod(), hms.getSubstitutor(), hms.isRaw());
                PsiClass containingClass = hms.getMethod().getContainingClass();
                ArrayList<HierarchicalMethodSignature> supers = new ArrayList<HierarchicalMethodSignature>(hms.getSuperSignatures());
                for (HierarchicalMethodSignature aSuper : supers) {
                    PsiClass superContainingClass = aSuper.getMethod().getContainingClass();
                    if (containingClass == null || superContainingClass == null || containingClass.isInheritor(superContainingClass, true)) continue;
                    flattened.add(Pair.create(signature, aSuper));
                }
                PsiSuperMethodImplUtil.putInMap(aClass2, result2, map2, hms, signature);
            }
            for (Pair pair : flattened) {
                PsiSuperMethodImplUtil.putInMap(aClass2, result2, map2, (HierarchicalMethodSignature)pair.second, (MethodSignature)pair.first);
            }
        }
        for (Map.Entry entry : map2.entrySet()) {
            HierarchicalMethodSignatureImpl hierarchicalMethodSignature = (HierarchicalMethodSignatureImpl)entry.getValue();
            MethodSignature methodSignature = (MethodSignature)entry.getKey();
            if (result2.get(methodSignature) != null) continue;
            LOG.assertTrue(hierarchicalMethodSignature.getMethod().isValid());
            result2.put(methodSignature, hierarchicalMethodSignature);
        }
        LinkedHashMap<MethodSignature, HierarchicalMethodSignature> linkedHashMap = result2;
        if (linkedHashMap == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(23);
        }
        return linkedHashMap;
    }

    private static void putInMap(@NotNull PsiClass aClass2, @NotNull Map<MethodSignature, HierarchicalMethodSignature> result2, @NotNull Map<MethodSignature, HierarchicalMethodSignatureImpl> map2, @NotNull HierarchicalMethodSignature hierarchicalMethodSignature, @NotNull MethodSignature signature) {
        HierarchicalMethodSignatureImpl existing;
        if (aClass2 == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(24);
        }
        if (result2 == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(25);
        }
        if (map2 == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(26);
        }
        if (hierarchicalMethodSignature == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(27);
        }
        if (signature == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(28);
        }
        if ((existing = map2.get(signature)) == null) {
            HierarchicalMethodSignatureImpl copy2 = PsiSuperMethodImplUtil.copy(hierarchicalMethodSignature);
            LOG.assertTrue(copy2.getMethod().isValid());
            map2.put(signature, copy2);
        } else if (PsiSuperMethodImplUtil.isReturnTypeIsMoreSpecificThan(hierarchicalMethodSignature, existing) && PsiSuperMethodImplUtil.isSuperMethod(aClass2, hierarchicalMethodSignature, existing)) {
            HierarchicalMethodSignatureImpl newSuper = PsiSuperMethodImplUtil.copy(hierarchicalMethodSignature);
            PsiSuperMethodImplUtil.mergeSupers(newSuper, existing);
            LOG.assertTrue(newSuper.getMethod().isValid());
            map2.put(signature, newSuper);
        } else if (PsiSuperMethodImplUtil.isSuperMethod(aClass2, existing, hierarchicalMethodSignature)) {
            PsiSuperMethodImplUtil.mergeSupers(existing, hierarchicalMethodSignature);
        } else if (!result2.containsKey(signature)) {
            LOG.assertTrue(hierarchicalMethodSignature.getMethod().isValid());
            result2.put(signature, hierarchicalMethodSignature);
        }
    }

    private static boolean isReturnTypeIsMoreSpecificThan(@NotNull HierarchicalMethodSignature thisSig, @NotNull HierarchicalMethodSignature thatSig) {
        PsiSubstitutor unifyingSubstitutor;
        if (thisSig == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(29);
        }
        if (thatSig == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(30);
        }
        PsiType thisRet = thisSig.getSubstitutor().substitute(thisSig.getMethod().getReturnType());
        PsiType thatRet = thatSig.getSubstitutor().substitute(thatSig.getMethod().getReturnType());
        PsiSubstitutor psiSubstitutor = unifyingSubstitutor = MethodSignatureUtil.isSubsignature(thatSig, thisSig) ? MethodSignatureUtil.getSuperMethodSignatureSubstitutor(thisSig, thatSig) : null;
        if (unifyingSubstitutor != null) {
            thisRet = unifyingSubstitutor.substitute(thisRet);
            thatRet = unifyingSubstitutor.substitute(thatRet);
        }
        return thatRet != null && thisRet != null && !thatRet.equals(thisRet) && TypeConversionUtil.isAssignable(thatRet, thisRet, false);
    }

    private static void mergeSupers(@NotNull HierarchicalMethodSignatureImpl existing, @NotNull HierarchicalMethodSignature superSignature) {
        if (existing == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(31);
        }
        if (superSignature == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(32);
        }
        for (HierarchicalMethodSignature existingSuper : existing.getSuperSignatures()) {
            if (existingSuper.getMethod() != superSignature.getMethod()) continue;
            for (HierarchicalMethodSignature signature : superSignature.getSuperSignatures()) {
                PsiSuperMethodImplUtil.mergeSupers((HierarchicalMethodSignatureImpl)existingSuper, signature);
            }
            return;
        }
        if (existing.getMethod() == superSignature.getMethod()) {
            List<HierarchicalMethodSignature> existingSupers = existing.getSuperSignatures();
            for (HierarchicalMethodSignature supers : superSignature.getSuperSignatures()) {
                if (existingSupers.contains(supers)) continue;
                existing.addSuperSignature(PsiSuperMethodImplUtil.copy(supers));
            }
        } else {
            HierarchicalMethodSignatureImpl copy2 = PsiSuperMethodImplUtil.copy(superSignature);
            existing.addSuperSignature(copy2);
        }
    }

    private static boolean isSuperMethod(@NotNull PsiClass aClass2, @NotNull MethodSignatureBackedByPsiMethod hierarchicalMethodSignature, @NotNull MethodSignatureBackedByPsiMethod superSignatureHierarchical) {
        if (aClass2 == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(33);
        }
        if (hierarchicalMethodSignature == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(34);
        }
        if (superSignatureHierarchical == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(35);
        }
        PsiMethod superMethod = superSignatureHierarchical.getMethod();
        PsiClass superClass = superMethod.getContainingClass();
        PsiMethod method = hierarchicalMethodSignature.getMethod();
        PsiClass containingClass = method.getContainingClass();
        if (!superMethod.isConstructor() && !aClass2.equals(superClass) && MethodSignatureUtil.isSubsignature(superSignatureHierarchical, hierarchicalMethodSignature) && superClass != null) {
            if (superClass.isInterface() || "java.lang.Object".equals(superClass.getQualifiedName())) {
                if (superMethod.hasModifierProperty("static") || superMethod.hasModifierProperty("default") && method.hasModifierProperty("static") && !InheritanceUtil.isInheritorOrSelf(containingClass, superClass, true)) {
                    return false;
                }
                if (superMethod.hasModifierProperty("default") || method.hasModifierProperty("default")) {
                    return superMethod.equals(method) || !InheritanceUtil.isInheritorOrSelf(superClass, containingClass, true);
                }
                return true;
            }
            if (containingClass != null) {
                if (containingClass.isInterface()) {
                    return false;
                }
                if (!aClass2.isInterface() && !InheritanceUtil.isInheritorOrSelf(superClass, containingClass, true)) {
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    private static HierarchicalMethodSignatureImpl copy(@NotNull HierarchicalMethodSignature hi) {
        if (hi == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(36);
        }
        HierarchicalMethodSignatureImpl hierarchicalMethodSignature = new HierarchicalMethodSignatureImpl(hi);
        for (HierarchicalMethodSignature his : hi.getSuperSignatures()) {
            hierarchicalMethodSignature.addSuperSignature(PsiSuperMethodImplUtil.copy(his));
        }
        HierarchicalMethodSignatureImpl hierarchicalMethodSignatureImpl = hierarchicalMethodSignature;
        if (hierarchicalMethodSignatureImpl == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(37);
        }
        return hierarchicalMethodSignatureImpl;
    }

    @NotNull
    public static Collection<HierarchicalMethodSignature> getVisibleSignatures(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(38);
        }
        Map<MethodSignature, HierarchicalMethodSignature> map2 = PsiSuperMethodImplUtil.getSignaturesMap(aClass2);
        Collection<HierarchicalMethodSignature> collection = map2.values();
        if (collection == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(39);
        }
        return collection;
    }

    @NotNull
    public static HierarchicalMethodSignature getHierarchicalMethodSignature(@NotNull PsiMethod method) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(40);
        }
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(method, method.getResolveScope());
        if (hierarchicalMethodSignature == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(41);
        }
        return hierarchicalMethodSignature;
    }

    @NotNull
    public static HierarchicalMethodSignature getHierarchicalMethodSignature(@NotNull PsiMethod method, @NotNull GlobalSearchScope resolveScope) {
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(42);
        }
        if (resolveScope == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(43);
        }
        Map signatures = (Map)CachedValuesManager.getCachedValue(method, () -> {
            ConcurrentMap<GlobalSearchScope, HierarchicalMethodSignature> map2 = ConcurrentFactoryMap.createMap(scope -> {
                PsiClass aClass2 = method.getContainingClass();
                MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
                HierarchicalMethodSignature result2 = null;
                if (aClass2 != null) {
                    result2 = SIGNATURES_BY_NAME_KEY.getValue(aClass2).get(Pair.create(method.getName(), scope)).get(signature);
                }
                if (result2 == null) {
                    result2 = new HierarchicalMethodSignatureImpl((MethodSignatureBackedByPsiMethod)signature);
                }
                return result2;
            });
            return CachedValueProvider.Result.create(map2, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
        HierarchicalMethodSignature hierarchicalMethodSignature = (HierarchicalMethodSignature)signatures.get(resolveScope);
        if (hierarchicalMethodSignature == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(44);
        }
        return hierarchicalMethodSignature;
    }

    @NotNull
    private static Map<MethodSignature, HierarchicalMethodSignature> getSignaturesMap(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(45);
        }
        Map<MethodSignature, HierarchicalMethodSignature> map2 = SIGNATURES_FOR_CLASS_KEY.getValue(aClass2);
        if (map2 == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(46);
        }
        return map2;
    }

    public static boolean processDirectSuperMethodsSmart(@NotNull PsiMethod method, @NotNull Processor<? super PsiMethod> superMethodProcessor) {
        PsiClass aClass2;
        if (method == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(47);
        }
        if (superMethodProcessor == null) {
            PsiSuperMethodImplUtil.$$$reportNull$$$0(48);
        }
        if ((aClass2 = method.getContainingClass()) == null) {
            return false;
        }
        if (!PsiSuperMethodImplUtil.canHaveSuperMethod(method, true, false)) {
            return false;
        }
        Map<MethodSignature, HierarchicalMethodSignature> cachedMap = SIGNATURES_BY_NAME_KEY.getValue(aClass2).get(Pair.create(method.getName(), method.getResolveScope()));
        HierarchicalMethodSignature signature = cachedMap.get(method.getSignature(PsiSubstitutor.EMPTY));
        if (signature != null) {
            List<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
            for (HierarchicalMethodSignature superSignature : superSignatures) {
                if (superMethodProcessor.process(superSignature.getMethod())) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 46: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiSuperMethodImplUtil";
                break;
            }
            case 20: 
            case 24: 
            case 33: 
            case 38: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchicalMethodSignature";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisSig";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thatSig";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSignature";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSignatureHierarchical";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hi";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiSuperMethodImplUtil";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethods";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethodsInternal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethodSignaturesIncludingStatic";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuperMethodSignatures";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeepestSuperMethods";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMethodHierarchy";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleSignatures";
                break;
            }
            case 41: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchicalMethodSignature";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSuperMethods";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 46: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSuperMethodsInternal";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findSuperMethodSignaturesIncludingStatic";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findSuperMethodSignatures";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canHaveSuperMethod";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findDeepestSuperMethod";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findDeepestSuperMethods";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildMethodHierarchy";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "putInMap";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isReturnTypeIsMoreSpecificThan";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "mergeSupers";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isSuperMethod";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleSignatures";
                break;
            }
            case 40: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchicalMethodSignature";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getSignaturesMap";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processDirectSuperMethodsSmart";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 23: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 46: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

