/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import org.gradle.api.internal.provider.AbstractMappingProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.internal.Cast;
import org.gradle.internal.DisplayName;

class TypeSanitizingProvider<T>
extends AbstractMappingProvider<T, T> {
    private final DisplayName owner;
    private final ValueSanitizer<? super T> sanitizer;
    private final Class<? super T> targetType;

    public TypeSanitizingProvider(DisplayName owner, ValueSanitizer<? super T> sanitizer, Class<? super T> targetType, ProviderInternal<? extends T> delegate) {
        super((Class)Cast.uncheckedNonnullCast(targetType), delegate);
        this.owner = owner;
        this.sanitizer = sanitizer;
        this.targetType = targetType;
    }

    @Override
    protected T mapValue(T v) {
        if (this.targetType.isInstance(v = Cast.uncheckedCast(this.sanitizer.sanitize(v)))) {
            return (T)v;
        }
        throw new IllegalArgumentException(String.format("Cannot get the value of %s of type %s as the provider associated with this property returned a value of type %s.", this.owner.getDisplayName(), this.targetType.getName(), v.getClass().getName()));
    }
}

