/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import com.google.common.base.Joiner;
import java.util.List;
import javax.annotation.CheckReturnValue;
import org.gradle.internal.deprecation.ConfigurationDeprecationType;
import org.gradle.internal.deprecation.DeprecatedFeatureUsage;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessage;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.deprecation.Messages;

@CheckReturnValue
public class DeprecationMessageBuilder<T extends DeprecationMessageBuilder<T>> {
    private String summary;
    private String removalDetails;
    private String context;
    private String advice;
    private Documentation documentation = Documentation.NO_DOCUMENTATION;
    private DeprecatedFeatureUsage.Type usageType = DeprecatedFeatureUsage.Type.USER_CODE_DIRECT;

    DeprecationMessageBuilder() {
    }

    public T withContext(String context) {
        this.context = context;
        return (T)this;
    }

    public T withAdvice(String advice) {
        this.advice = advice;
        return (T)this;
    }

    public WithDocumentation undocumented() {
        return new WithDocumentation(this);
    }

    public WithDocumentation withUserManual(String documentationId) {
        this.documentation = Documentation.userManual(documentationId);
        return new WithDocumentation(this);
    }

    public WithDocumentation withUserManual(String documentationId, String section) {
        this.documentation = Documentation.userManual(documentationId, section);
        return new WithDocumentation(this);
    }

    public WithDocumentation withDslReference(Class<?> targetClass, String property) {
        this.documentation = Documentation.dslReference(targetClass, property);
        return new WithDocumentation(this);
    }

    public WithDocumentation withUpgradeGuideSection(int majorVersion, String upgradeGuideSection) {
        this.documentation = Documentation.upgradeGuide(majorVersion, upgradeGuideSection);
        return new WithDocumentation(this);
    }

    void setIndirectUsage() {
        this.usageType = DeprecatedFeatureUsage.Type.USER_CODE_INDIRECT;
    }

    void setBuildInvocationUsage() {
        this.usageType = DeprecatedFeatureUsage.Type.BUILD_INVOCATION;
    }

    void setSummary(String summary) {
        this.summary = summary;
    }

    void setAdvice(String advice) {
        this.advice = advice;
    }

    void setRemovalDetails(String removalDetails) {
        this.removalDetails = removalDetails;
    }

    void setDocumentation(Documentation documentation) {
        this.documentation = documentation;
    }

    DeprecationMessage build() {
        return new DeprecationMessage(this.summary, this.removalDetails, this.advice, this.context, this.documentation, this.usageType);
    }

    public static class DeprecateInternalApi
    extends WithReplacement<String, DeprecateInternalApi> {
        DeprecateInternalApi(String api) {
            super(api);
        }

        @Override
        String formatSummary(String api) {
            return String.format("Internal API %s has been deprecated.", api);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use %s instead.", replacement);
        }
    }

    public static class DeprecatePlugin
    extends WithReplacement<String, DeprecatePlugin> {
        private boolean externalReplacement = false;

        DeprecatePlugin(String plugin) {
            super(plugin);
        }

        @Override
        String formatSummary(String plugin) {
            return String.format("The %s plugin has been deprecated.", plugin);
        }

        @Override
        String formatAdvice(String replacement) {
            return this.externalReplacement ? String.format("Consider using the %s plugin instead.", replacement) : String.format("Please use the %s plugin instead.", replacement);
        }

        public DeprecatePlugin replaceWithExternalPlugin(String replacement) {
            this.externalReplacement = true;
            return (DeprecatePlugin)this.replaceWith(replacement);
        }
    }

    public static class DeprecateTask
    extends WithReplacement<String, DeprecateTask> {
        DeprecateTask(String task) {
            super(task);
        }

        @Override
        String formatSummary(String task) {
            return String.format("The %s task has been deprecated.", task);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use the %s task instead.", replacement);
        }
    }

    public static class DeprecateInvocation
    extends WithReplacement<String, DeprecateInvocation> {
        DeprecateInvocation(String invocation) {
            super(invocation);
        }

        @Override
        String formatSummary(String invocation) {
            return String.format("Using method %s has been deprecated.", invocation);
        }

        @Override
        String formatAdvice(String replacement) {
            return Messages.pleaseUseThisMethodInstead(replacement);
        }

        @Override
        String removalDetails() {
            return Messages.thisWillBecomeAnError();
        }
    }

    public static class DeprecateMethod
    extends WithReplacement<String, DeprecateMethod> {
        private final Class<?> methodClass;
        private final String methodWithParams;

        DeprecateMethod(Class<?> methodClass, String methodWithParams) {
            super(methodWithParams);
            this.methodClass = methodClass;
            this.methodWithParams = methodWithParams;
        }

        @Override
        String formatSubject() {
            return String.format("%s.%s", this.methodClass.getSimpleName(), this.methodWithParams);
        }

        @Override
        String formatSummary(String method) {
            return String.format("The %s method has been deprecated.", method);
        }

        @Override
        String formatAdvice(String replacement) {
            return Messages.pleaseUseThisMethodInstead(replacement);
        }
    }

    public static class DeprecateConfiguration
    extends WithReplacement<List<String>, DeprecateConfiguration> {
        private final ConfigurationDeprecationType deprecationType;

        DeprecateConfiguration(String configuration, ConfigurationDeprecationType deprecationType) {
            super(configuration);
            this.deprecationType = deprecationType;
            if (!deprecationType.inUserCode) {
                this.setIndirectUsage();
            }
        }

        @Override
        String formatSummary(String configuration) {
            return String.format("The %s configuration has been deprecated for %s.", configuration, this.deprecationType.displayName());
        }

        @Override
        String formatAdvice(List<String> replacements) {
            return String.format("Please %s the %s configuration instead.", this.deprecationType.usage, Joiner.on((String)" or ").join(replacements));
        }

        @Override
        String removalDetails() {
            return Messages.thisWillBecomeAnError();
        }
    }

    @CheckReturnValue
    public static class ConfigurationDeprecationTypeSelector {
        private final String configuration;

        ConfigurationDeprecationTypeSelector(String configuration) {
            this.configuration = configuration;
        }

        public DeprecateConfiguration forArtifactDeclaration() {
            return new DeprecateConfiguration(this.configuration, ConfigurationDeprecationType.ARTIFACT_DECLARATION);
        }

        public DeprecateConfiguration forConsumption() {
            return new DeprecateConfiguration(this.configuration, ConfigurationDeprecationType.CONSUMPTION);
        }

        public DeprecateConfiguration forDependencyDeclaration() {
            return new DeprecateConfiguration(this.configuration, ConfigurationDeprecationType.DEPENDENCY_DECLARATION);
        }

        public DeprecateConfiguration forResolution() {
            return new DeprecateConfiguration(this.configuration, ConfigurationDeprecationType.RESOLUTION);
        }
    }

    public static class DeprecateProperty
    extends WithReplacement<String, DeprecateProperty> {
        private final Class<?> propertyClass;
        private final String property;

        DeprecateProperty(Class<?> propertyClass, String property) {
            super(property);
            this.propertyClass = propertyClass;
            this.property = property;
        }

        public WithDocumentation withDslReference() {
            this.setDocumentation(Documentation.dslReference(this.propertyClass, this.property));
            return new WithDocumentation(this);
        }

        @Override
        String formatSubject() {
            return String.format("%s.%s", this.propertyClass.getSimpleName(), this.property);
        }

        @Override
        String formatSummary(String property) {
            return String.format("The %s property has been deprecated.", property);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use the %s property instead.", replacement);
        }
    }

    public static class DeprecateNamedParameter
    extends WithReplacement<String, DeprecateNamedParameter> {
        DeprecateNamedParameter(String parameter) {
            super(parameter);
        }

        @Override
        String formatSummary(String parameter) {
            return String.format("The %s named parameter has been deprecated.", parameter);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use the %s named parameter instead.", replacement);
        }
    }

    public static abstract class WithReplacement<T, SELF extends WithReplacement<T, SELF>>
    extends DeprecationMessageBuilder<SELF> {
        private final String subject;
        private T replacement;

        WithReplacement(String subject) {
            this.subject = subject;
        }

        public SELF replaceWith(T replacement) {
            this.replacement = replacement;
            return (SELF)this;
        }

        String formatSubject() {
            return this.subject;
        }

        abstract String formatSummary(String var1);

        abstract String formatAdvice(T var1);

        String removalDetails() {
            return Messages.thisIsScheduledToBeRemoved();
        }

        @Override
        DeprecationMessage build() {
            this.setSummary(this.formatSummary(this.formatSubject()));
            this.setRemovalDetails(this.removalDetails());
            if (this.replacement != null) {
                this.setAdvice(this.formatAdvice(this.replacement));
            }
            return super.build();
        }
    }

    public static class WithDocumentation {
        private final DeprecationMessageBuilder<?> builder;

        public WithDocumentation(DeprecationMessageBuilder<?> builder) {
            this.builder = builder;
        }

        public void nagUser() {
            DeprecationLogger.nagUserWith(this.builder, WithDocumentation.class);
        }
    }
}

