/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.GUtil;

public abstract class ModuleNotationValidation {
    private static final List<Character> INVALID_SPEC_CHARS = Lists.newArrayList((Object[])new Character[]{Character.valueOf('*'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(',')});

    public static String validate(String part, String notation) {
        if (!GUtil.isTrue((Object)part)) {
            throw new UnsupportedNotationException((Object)notation);
        }
        for (char c : INVALID_SPEC_CHARS) {
            if (part.indexOf(c) == -1) continue;
            throw new UnsupportedNotationException((Object)notation);
        }
        return part;
    }

    public static String validate(String part) {
        return ModuleNotationValidation.validate(part, part);
    }
}

