/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.internal.jacoco.JacocoAgentJar;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaForkOptions;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;

public class JacocoPluginExtension {
    public static final String TASK_EXTENSION_NAME = "jacoco";
    private static final Logger LOGGER = Logging.getLogger(JacocoPluginExtension.class);
    protected final Project project;
    private final ProviderFactory providerFactory;
    private final ProjectLayout projectLayout;
    private final FileOperations fileOperations;
    private final JacocoAgentJar agent;
    private String toolVersion;
    private final Property<File> reportsDir;

    public JacocoPluginExtension(Project project, JacocoAgentJar agent) {
        this.project = project;
        this.agent = agent;
        this.providerFactory = project.getProviders();
        this.projectLayout = project.getLayout();
        this.fileOperations = (FileOperations)((ProjectInternal)project).getServices().get(FileOperations.class);
        this.reportsDir = project.getObjects().property(File.class);
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    public File getReportsDir() {
        return (File)this.reportsDir.get();
    }

    public void setReportsDir(Provider<File> reportsDir) {
        this.reportsDir.set(reportsDir);
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir.set((Object)reportsDir);
    }

    public <T extends Task & JavaForkOptions> void applyTo(T task) {
        final String taskName = task.getName();
        LOGGER.debug("Applying Jacoco to " + taskName);
        final JacocoTaskExtension extension = (JacocoTaskExtension)task.getExtensions().create(TASK_EXTENSION_NAME, JacocoTaskExtension.class, new Object[]{this.project, this.agent, task});
        extension.setDestinationFile((Provider<File>)this.providerFactory.provider((Callable)new Callable<File>(){

            @Override
            public File call() {
                return JacocoPluginExtension.this.fileOperations.file((Object)(((Directory)JacocoPluginExtension.this.projectLayout.getBuildDirectory().get()).getAsFile() + "/jacoco/" + taskName + ".exec"));
            }
        }));
        ((JavaForkOptions)task).getJvmArgumentProviders().add(new JacocoAgent(extension));
        task.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                if (extension.isEnabled() && extension.getOutput() == JacocoTaskExtension.Output.FILE) {
                    File coverageFile = extension.getDestinationFile();
                    if (coverageFile == null) {
                        throw new GradleException("JaCoCo destination file must not be null if output type is FILE");
                    }
                    JacocoPluginExtension.this.fileOperations.delete(new Object[]{coverageFile});
                }
            }
        });
        task.getOutputs().doNotCacheIf("JaCoCo configured to not produce its output as a file", (Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return extension.isEnabled() && extension.getOutput() != JacocoTaskExtension.Output.FILE;
            }
        });
    }

    public <T extends Task & JavaForkOptions> void applyTo(TaskCollection<T> tasks) {
        tasks.withType(JavaForkOptions.class, new Action<T>(){

            public void execute(T task) {
                JacocoPluginExtension.this.applyTo(task);
            }
        });
    }

    private static class JacocoAgent
    implements CommandLineArgumentProvider,
    Named {
        private final JacocoTaskExtension jacoco;

        public JacocoAgent(JacocoTaskExtension jacoco) {
            this.jacoco = jacoco;
        }

        @Nullable
        @Optional
        @Nested
        public JacocoTaskExtension getJacoco() {
            return this.jacoco.isEnabled() ? this.jacoco : null;
        }

        public Iterable<String> asArguments() {
            return this.jacoco.isEnabled() ? ImmutableList.of((Object)this.jacoco.getAsJvmArg()) : Collections.emptyList();
        }

        @Internal
        public String getName() {
            return "jacocoAgent";
        }
    }
}

