/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.distribution.Distribution;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.distribution.plugins.DistributionPlugin;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.DefaultApplicationPluginConvention;
import org.gradle.api.plugins.internal.DefaultJavaApplication;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.application.CreateStartScripts;

public class ApplicationPlugin
implements Plugin<Project> {
    public static final String APPLICATION_PLUGIN_NAME = "application";
    public static final String APPLICATION_GROUP = "application";
    public static final String TASK_RUN_NAME = "run";
    public static final String TASK_START_SCRIPTS_NAME = "startScripts";
    public static final String TASK_DIST_ZIP_NAME = "distZip";
    public static final String TASK_DIST_TAR_NAME = "distTar";

    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        project.getPluginManager().apply(DistributionPlugin.class);
        ApplicationPluginConvention pluginConvention = this.addExtensions(project);
        this.addRunTask(project, pluginConvention);
        this.addCreateScriptsTask(project, pluginConvention);
        this.configureInstallTask((TaskProvider<Sync>)project.getTasks().named("installDist", Sync.class), pluginConvention);
        DistributionContainer distributions = (DistributionContainer)project.getExtensions().getByName("distributions");
        Distribution mainDistribution = (Distribution)distributions.getByName("main");
        this.configureDistribution(project, mainDistribution, pluginConvention);
    }

    private void configureInstallTask(TaskProvider<Sync> installTask, ApplicationPluginConvention pluginConvention) {
        installTask.configure(task -> task.doFirst("don't overwrite existing directories", (Action)new PreventDestinationOverwrite(pluginConvention)));
    }

    private ApplicationPluginConvention addExtensions(Project project) {
        DefaultApplicationPluginConvention pluginConvention = new DefaultApplicationPluginConvention(project);
        ((ApplicationPluginConvention)pluginConvention).setApplicationName(project.getName());
        project.getConvention().getPlugins().put("application", pluginConvention);
        project.getExtensions().create(JavaApplication.class, "application", DefaultJavaApplication.class, new Object[]{pluginConvention});
        return pluginConvention;
    }

    private void addRunTask(Project project, ApplicationPluginConvention pluginConvention) {
        project.getTasks().register(TASK_RUN_NAME, JavaExec.class, run -> {
            run.setDescription("Runs this project as a JVM application");
            run.setGroup("application");
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            run.setClasspath(((SourceSet)javaPluginConvention.getSourceSets().getByName("main")).getRuntimeClasspath());
            run.getConventionMapping().map("main", pluginConvention::getMainClassName);
            run.getConventionMapping().map("jvmArgs", pluginConvention::getApplicationDefaultJvmArgs);
        });
    }

    private void addCreateScriptsTask(Project project, ApplicationPluginConvention pluginConvention) {
        project.getTasks().register(TASK_START_SCRIPTS_NAME, CreateStartScripts.class, startScripts -> {
            startScripts.setDescription("Creates OS specific scripts to run the project as a JVM application.");
            startScripts.setClasspath(project.getTasks().getAt("jar").getOutputs().getFiles().plus((FileCollection)project.getConfigurations().getByName("runtimeClasspath")));
            startScripts.getConventionMapping().map("mainClassName", pluginConvention::getMainClassName);
            startScripts.getConventionMapping().map("applicationName", pluginConvention::getApplicationName);
            startScripts.getConventionMapping().map("outputDir", () -> new File(project.getBuildDir(), "scripts"));
            startScripts.getConventionMapping().map("executableDir", pluginConvention::getExecutableDir);
            startScripts.getConventionMapping().map("defaultJvmOpts", pluginConvention::getApplicationDefaultJvmArgs);
        });
    }

    private CopySpec configureDistribution(Project project, Distribution mainDistribution, ApplicationPluginConvention pluginConvention) {
        mainDistribution.getDistributionBaseName().convention(project.provider(pluginConvention::getApplicationName));
        CopySpec distSpec = mainDistribution.getContents();
        TaskProvider jar = project.getTasks().named("jar");
        TaskProvider startScripts = project.getTasks().named(TASK_START_SCRIPTS_NAME);
        CopySpec libChildSpec = project.copySpec();
        libChildSpec.into((Object)"lib");
        libChildSpec.from(new Object[]{jar});
        libChildSpec.from(new Object[]{project.getConfigurations().named("runtimeClasspath")});
        CopySpec binChildSpec = project.copySpec();
        binChildSpec.into(pluginConvention::getExecutableDir);
        binChildSpec.from(new Object[]{startScripts});
        binChildSpec.setFileMode(Integer.valueOf(493));
        CopySpec childSpec = project.copySpec();
        childSpec.from(new Object[]{project.file((Object)"src/dist")});
        childSpec.with(new CopySpec[]{libChildSpec});
        childSpec.with(new CopySpec[]{binChildSpec});
        distSpec.with(new CopySpec[]{childSpec});
        distSpec.with(new CopySpec[]{pluginConvention.getApplicationDistribution()});
        return distSpec;
    }

    private static class PreventDestinationOverwrite
    implements Action<Task> {
        private final ApplicationPluginConvention pluginConvention;

        private PreventDestinationOverwrite(ApplicationPluginConvention pluginConvention) {
            this.pluginConvention = pluginConvention;
        }

        public void execute(Task task) {
            Sync sync = (Sync)task;
            File destinationDir = sync.getDestinationDir();
            if (destinationDir.isDirectory()) {
                String[] children = destinationDir.list();
                if (children == null) {
                    throw new UncheckedIOException("Could not list directory " + destinationDir);
                }
                if (!(children.length <= 0 || new File(destinationDir, "lib").isDirectory() && new File(destinationDir, this.pluginConvention.getExecutableDir()).isDirectory())) {
                    throw new GradleException("The specified installation directory '" + destinationDir + "' is neither empty nor does it contain an installation for '" + this.pluginConvention.getApplicationName() + "'.\nIf you really want to install to this directory, delete it and run the install task again.\nAlternatively, choose a different installation directory.");
                }
            }
        }
    }
}

