/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.tasks.PropertyFileCollection;
import org.gradle.api.internal.tasks.properties.DefaultCacheableOutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.DirectoryTreeOutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.FilePropertySpec;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.AbsolutePathInputNormalizer;
import org.gradle.internal.fingerprint.IgnoredPathInputNormalizer;
import org.gradle.internal.fingerprint.NameOnlyInputNormalizer;
import org.gradle.internal.fingerprint.RelativePathInputNormalizer;
import org.gradle.util.DeferredUtil;

public class FileParameterUtils {
    public static Class<? extends FileNormalizer> determineNormalizerForPathSensitivity(PathSensitivity pathSensitivity) {
        switch (pathSensitivity) {
            case NONE: {
                return IgnoredPathInputNormalizer.class;
            }
            case NAME_ONLY: {
                return NameOnlyInputNormalizer.class;
            }
            case RELATIVE: {
                return RelativePathInputNormalizer.class;
            }
            case ABSOLUTE: {
                return AbsolutePathInputNormalizer.class;
            }
        }
        throw new IllegalArgumentException("Unknown path sensitivity: " + pathSensitivity);
    }

    public static Class<? extends FileNormalizer> normalizerOrDefault(@Nullable Class<? extends FileNormalizer> fileNormalizer) {
        return fileNormalizer == null ? AbsolutePathInputNormalizer.class : fileNormalizer;
    }

    public static <T extends FilePropertySpec> ImmutableSortedSet<T> collectFileProperties(String displayName, Iterator<? extends T> fileProperties) {
        HashSet names = Sets.newHashSet();
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        while (fileProperties.hasNext()) {
            FilePropertySpec propertySpec = (FilePropertySpec)fileProperties.next();
            String propertyName = propertySpec.getPropertyName();
            if (!names.add(propertyName)) {
                throw new IllegalArgumentException(String.format("Multiple %s file properties with name '%s'", displayName, propertyName));
            }
            builder.add((Object)propertySpec);
        }
        return builder.build();
    }

    public static FileCollection resolveInputFileValue(FileCollectionFactory fileCollectionFactory, InputFilePropertyType inputFilePropertyType, Object path) {
        if (inputFilePropertyType == InputFilePropertyType.DIRECTORY) {
            return fileCollectionFactory.resolving(new Object[]{path}).getAsFileTree();
        }
        return fileCollectionFactory.resolving(new Object[]{path});
    }

    public static void resolveOutputFilePropertySpecs(String ownerDisplayName, String propertyName, PropertyValue value, OutputFilePropertyType filePropertyType, FileCollectionFactory fileCollectionFactory, Consumer<OutputFilePropertySpec> consumer) {
        Object unpackedValue = DeferredUtil.unpack((Object)value);
        if (unpackedValue == null) {
            return;
        }
        if (filePropertyType == OutputFilePropertyType.DIRECTORIES || filePropertyType == OutputFilePropertyType.FILES) {
            FileParameterUtils.resolveCompositeOutputFilePropertySpecs(ownerDisplayName, propertyName, unpackedValue, filePropertyType.getOutputType(), fileCollectionFactory, consumer);
        } else {
            FileCollectionInternal outputFiles = fileCollectionFactory.resolving(new Object[]{unpackedValue});
            DefaultCacheableOutputFilePropertySpec filePropertySpec = new DefaultCacheableOutputFilePropertySpec(propertyName, null, (FileCollection)outputFiles, filePropertyType.getOutputType());
            consumer.accept(filePropertySpec);
        }
    }

    private static void resolveCompositeOutputFilePropertySpecs(final String ownerDisplayName, final String propertyName, Object unpackedValue, final TreeType outputType, final FileCollectionFactory fileCollectionFactory, final Consumer<OutputFilePropertySpec> consumer) {
        if (unpackedValue instanceof Map) {
            for (Map.Entry entry : ((Map)unpackedValue).entrySet()) {
                Object key = entry.getKey();
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Mapped output property '%s' has null key", propertyName));
                }
                String id = key.toString();
                FileCollectionInternal outputFiles = fileCollectionFactory.resolving(new Object[]{entry.getValue()});
                consumer.accept(new DefaultCacheableOutputFilePropertySpec(propertyName, "." + id, (FileCollection)outputFiles, outputType));
            }
        } else {
            FileCollectionInternal outputFileCollection = fileCollectionFactory.resolving(new Object[]{unpackedValue});
            final AtomicInteger index = new AtomicInteger(0);
            outputFileCollection.visitStructure(new FileCollectionStructureVisitor(){

                public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
                    for (File content : contents) {
                        FileCollectionInternal outputFiles = fileCollectionFactory.fixed(new File[]{content});
                        consumer.accept(new DefaultCacheableOutputFilePropertySpec(propertyName, "$" + index.incrementAndGet(), (FileCollection)outputFiles, outputType));
                    }
                }

                public void visitGenericFileTree(FileTreeInternal fileTree) {
                    FileParameterUtils.failOnInvalidOutputType(fileTree);
                }

                public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree) {
                    FileParameterUtils.failOnInvalidOutputType(fileTree);
                }

                public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
                    consumer.accept(new DirectoryTreeOutputFilePropertySpec(propertyName + "$" + index.incrementAndGet(), (FileCollection)new PropertyFileCollection(ownerDisplayName, propertyName, "output", (FileCollection)fileTree), root));
                }
            });
        }
    }

    private static void failOnInvalidOutputType(FileTreeInternal fileTree) {
        throw new InvalidUserDataException(String.format("Only files and directories can be registered as outputs (was: %s)", fileTree));
    }
}

