/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.WellKnownFileLocations;

public class SplitFileHasher
implements FileHasher {
    private final FileHasher globalHasher;
    private final FileHasher localHasher;
    private final WellKnownFileLocations wellKnownFileLocations;

    public SplitFileHasher(FileHasher globalHasher, FileHasher localHasher, WellKnownFileLocations wellKnownFileLocations) {
        this.globalHasher = globalHasher;
        this.localHasher = localHasher;
        this.wellKnownFileLocations = wellKnownFileLocations;
    }

    public HashCode hash(File file) {
        if (this.wellKnownFileLocations.isImmutable(file.getPath())) {
            return this.globalHasher.hash(file);
        }
        return this.localHasher.hash(file);
    }

    public HashCode hash(File file, long length, long lastModified) {
        if (this.wellKnownFileLocations.isImmutable(file.getPath())) {
            return this.globalHasher.hash(file, length, lastModified);
        }
        return this.localHasher.hash(file, length, lastModified);
    }
}

