/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.diagnostics.AbstractReportTask;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.dependencies.AsciiDependencyReportRenderer;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.deprecation.DeprecatableConfiguration;

public abstract class AbstractDependencyReportTask
extends AbstractReportTask {
    private DependencyReportRenderer renderer = new AsciiDependencyReportRenderer();
    private Set<Configuration> configurations;

    @Override
    public ReportRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(DependencyReportRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public void generate(Project project) throws IOException {
        TreeSet<Configuration> sortedConfigurations = new TreeSet<Configuration>(new Comparator<Configuration>(){

            @Override
            public int compare(Configuration conf1, Configuration conf2) {
                return conf1.getName().compareTo(conf2.getName());
            }
        });
        sortedConfigurations.addAll(this.getReportConfigurations());
        for (Configuration configuration : sortedConfigurations) {
            this.renderer.startConfiguration(configuration);
            this.renderer.render(configuration);
            this.renderer.completeConfiguration(configuration);
        }
    }

    private Set<Configuration> getReportConfigurations() {
        return this.configurations != null ? this.configurations : this.getNonDeprecatedTaskConfigurations();
    }

    @Internal
    public Set<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Set<Configuration> configurations) {
        this.configurations = configurations;
    }

    @Option(option="configuration", description="The configuration to generate the report for.")
    public void setConfiguration(String configurationName) {
        this.configurations = Collections.singleton(this.getTaskConfigurations().getByName(configurationName));
    }

    private Set<Configuration> getNonDeprecatedTaskConfigurations() {
        HashSet<Configuration> filteredConfigurations = new HashSet<Configuration>();
        for (Configuration configuration : this.getTaskConfigurations()) {
            if (((DeprecatableConfiguration)configuration).isFullyDeprecated()) continue;
            filteredConfigurations.add(configuration);
        }
        return filteredConfigurations;
    }

    @Internal
    public abstract ConfigurationContainer getTaskConfigurations();
}

