/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.initialization.AbstractClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.RootClassLoaderScope;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.initialization.ClassLoaderScopeRegistry;
import org.gradle.initialization.ClassLoaderScopeRegistryListener;

public class DefaultClassLoaderScopeRegistry
implements ClassLoaderScopeRegistry {
    public static final String CORE_NAME = "core";
    public static final String CORE_AND_PLUGINS_NAME = "coreAndPlugins";
    private final AbstractClassLoaderScope coreAndPluginsScope;
    private final AbstractClassLoaderScope coreScope;

    public DefaultClassLoaderScopeRegistry(ClassLoaderRegistry loaderRegistry, ClassLoaderCache classLoaderCache, ClassLoaderScopeRegistryListener listener) {
        this.coreScope = new RootClassLoaderScope(CORE_NAME, loaderRegistry.getRuntimeClassLoader(), loaderRegistry.getGradleCoreApiClassLoader(), classLoaderCache, listener);
        this.coreAndPluginsScope = new RootClassLoaderScope(CORE_AND_PLUGINS_NAME, loaderRegistry.getPluginsClassLoader(), loaderRegistry.getGradleApiClassLoader(), classLoaderCache, listener);
        this.rootScopesCreated(listener);
    }

    @Override
    public ClassLoaderScope getCoreAndPluginsScope() {
        return this.coreAndPluginsScope;
    }

    @Override
    public ClassLoaderScope getCoreScope() {
        return this.coreScope;
    }

    private void rootScopesCreated(ClassLoaderScopeRegistryListener listener) {
        listener.rootScopeCreated(this.coreScope.getId());
        listener.rootScopeCreated(this.coreAndPluginsScope.getId());
    }
}

