/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.internal.btree.Block;
import org.gradle.cache.internal.btree.BlockPayload;
import org.gradle.cache.internal.btree.BlockPointer;
import org.gradle.cache.internal.btree.BlockStore;
import org.gradle.cache.internal.btree.ByteInput;
import org.gradle.cache.internal.btree.ByteOutput;
import org.gradle.cache.internal.btree.CorruptedCacheException;

public class FileBackedBlockStore
implements BlockStore {
    private final File cacheFile;
    private RandomAccessFile file;
    private ByteOutput output;
    private ByteInput input;
    private long nextBlock;
    private BlockStore.Factory factory;
    private long currentFileSize;

    public FileBackedBlockStore(File cacheFile) {
        this.cacheFile = cacheFile;
    }

    public String toString() {
        return "cache '" + this.cacheFile + "'";
    }

    @Override
    public void open(Runnable runnable, BlockStore.Factory factory) {
        this.factory = factory;
        try {
            this.cacheFile.getParentFile().mkdirs();
            this.file = new RandomAccessFile(this.cacheFile, "rw");
            this.output = new ByteOutput(this.file);
            this.input = new ByteInput(this.file);
            this.nextBlock = this.currentFileSize = this.file.length();
            if (this.currentFileSize == 0L) {
                runnable.run();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    @Override
    public void clear() {
        try {
            this.file.setLength(0L);
            this.currentFileSize = 0L;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        this.nextBlock = 0L;
    }

    @Override
    public void attach(BlockPayload block) {
        if (block.getBlock() == null) {
            block.setBlock(new BlockImpl(block));
        }
    }

    @Override
    public void remove(BlockPayload block) {
        BlockImpl blockImpl = (BlockImpl)block.getBlock();
        blockImpl.detach();
    }

    @Override
    public void flush() {
    }

    @Override
    public <T extends BlockPayload> T readFirst(Class<T> payloadType) {
        return this.read(BlockPointer.pos(0L), payloadType);
    }

    @Override
    public <T extends BlockPayload> T read(BlockPointer pos, Class<T> payloadType) {
        assert (!pos.isNull());
        try {
            BlockPayload payload = (BlockPayload)payloadType.cast(this.factory.create(payloadType));
            BlockImpl block = new BlockImpl(payload, pos);
            block.read();
            return (T)payload;
        }
        catch (CorruptedCacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    @Override
    public void write(BlockPayload block) {
        BlockImpl blockImpl = (BlockImpl)block.getBlock();
        try {
            blockImpl.write();
        }
        catch (CorruptedCacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private long alloc(long length) {
        long pos = this.nextBlock;
        this.nextBlock += length;
        return pos;
    }

    private final class BlockImpl
    extends Block {
        private static final int HEADER_SIZE = 5;
        private static final int TAIL_SIZE = 4;
        private BlockPointer pos;
        private int payloadSize;

        private BlockImpl(BlockPayload payload, BlockPointer pos) {
            this(payload);
            this.setPos(pos);
        }

        public BlockImpl(BlockPayload payload) {
            super(payload);
            this.pos = null;
            this.payloadSize = -1;
        }

        @Override
        public boolean hasPos() {
            return this.pos != null;
        }

        @Override
        public BlockPointer getPos() {
            if (this.pos == null) {
                this.pos = BlockPointer.pos(FileBackedBlockStore.this.alloc(this.getSize()));
            }
            return this.pos;
        }

        @Override
        public void setPos(BlockPointer pos) {
            assert (this.pos == null && !pos.isNull());
            this.pos = pos;
        }

        @Override
        public int getSize() {
            if (this.payloadSize < 0) {
                this.payloadSize = this.getPayload().getSize();
            }
            return this.payloadSize + 5 + 4;
        }

        @Override
        public void setSize(int size) {
            int newPayloadSize = size - 5 - 4;
            assert (newPayloadSize >= this.payloadSize);
            this.payloadSize = newPayloadSize;
        }

        public void write() throws Exception {
            long pos = this.getPos().getPos();
            DataOutputStream outputStream = FileBackedBlockStore.this.output.start(pos);
            BlockPayload payload = this.getPayload();
            outputStream.writeByte(payload.getType());
            outputStream.writeInt(this.payloadSize);
            long finalSize = pos + 5L + 4L + (long)this.payloadSize;
            payload.write(outputStream);
            long bytesWritten = FileBackedBlockStore.this.output.getBytesWritten();
            if (bytesWritten > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Block payload exceeds maximum size");
            }
            outputStream.writeInt((int)bytesWritten);
            FileBackedBlockStore.this.output.done();
            if (FileBackedBlockStore.this.currentFileSize < finalSize) {
                FileBackedBlockStore.this.file.setLength(finalSize);
                FileBackedBlockStore.this.currentFileSize = finalSize;
            }
        }

        public void read() throws Exception {
            long pos = this.getPos().getPos();
            assert (pos >= 0L);
            if (pos + 5L >= FileBackedBlockStore.this.currentFileSize) {
                throw this.blockCorruptedException();
            }
            DataInputStream inputStream = FileBackedBlockStore.this.input.start(pos);
            BlockPayload payload = this.getPayload();
            byte type = inputStream.readByte();
            if (type != payload.getType()) {
                throw this.blockCorruptedException();
            }
            this.payloadSize = inputStream.readInt();
            if (pos + 5L + 4L + (long)this.payloadSize > FileBackedBlockStore.this.currentFileSize) {
                throw this.blockCorruptedException();
            }
            payload.read(inputStream);
            long actualCount = FileBackedBlockStore.this.input.getBytesRead();
            long count = inputStream.readInt();
            if (actualCount != count) {
                throw this.blockCorruptedException();
            }
            FileBackedBlockStore.this.input.done();
        }

        @Override
        public RuntimeException blockCorruptedException() {
            return new CorruptedCacheException(String.format("Corrupted %s found in %s.", this, FileBackedBlockStore.this));
        }
    }
}

