/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.kotlin.com.intellij.util.io.ByteBufferWrapper;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

abstract class DirectBufferWrapper
extends ByteBufferWrapper {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.util.io.DirectBufferWrapper");
    private volatile ByteBuffer myBuffer;

    DirectBufferWrapper(File file2, long offset2, long length) {
        super(file2, offset2, length);
    }

    @Override
    public ByteBuffer getCachedBuffer() {
        return this.myBuffer;
    }

    @Override
    public ByteBuffer getBuffer() throws IOException {
        ByteBuffer buffer = this.myBuffer;
        if (buffer == null) {
            this.myBuffer = buffer = this.create();
        }
        return buffer;
    }

    protected abstract ByteBuffer create() throws IOException;

    @Override
    public void unmap() {
        if (this.isDirty()) {
            this.flush();
        }
        if (this.myBuffer != null) {
            DirectBufferWrapper.disposeDirectBuffer(this.myBuffer);
        }
        this.myBuffer = null;
    }

    static boolean disposeDirectBuffer(ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            return true;
        }
        if (SystemInfo.IS_AT_LEAST_JAVA9) {
            Unsafe unsafe = AtomicFieldUpdater.getUnsafe();
            try {
                Method invokeCleaner = unsafe.getClass().getMethod("invokeCleaner", ByteBuffer.class);
                invokeCleaner.setAccessible(true);
                invokeCleaner.invoke((Object)unsafe, buffer);
                return true;
            }
            catch (Exception e) {
                LOG.error(e);
                throw new RuntimeException(e);
            }
        }
        try {
            Cleaner cleaner = ((DirectBuffer)((Object)buffer)).cleaner();
            if (cleaner != null) {
                cleaner.clean();
            }
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

