/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.ManagedFactories;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public class DefaultProperty<T>
extends AbstractProperty<T>
implements Property<T> {
    private final Class<T> type;
    private final ValueSanitizer<T> sanitizer;
    private ProviderInternal<? extends T> convention = Providers.notDefined();
    private ProviderInternal<? extends T> provider;

    public DefaultProperty(Class<T> type) {
        this.applyDefaultValue();
        this.type = type;
        this.sanitizer = ValueSanitizers.forType(type);
    }

    @Override
    public Class<?> publicType() {
        return Property.class;
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.PropertyManagedFactory.FACTORY_ID;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        if (super.maybeVisitBuildDependencies(context)) {
            return true;
        }
        return this.provider.maybeVisitBuildDependencies(context);
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            this.set(object);
        }
    }

    public void set(T value) {
        if (value == null) {
            if (this.beforeReset()) {
                this.provider = this.convention;
            }
            return;
        }
        if (this.beforeMutate()) {
            if (!this.type.isInstance(value = this.sanitizer.sanitize(value))) {
                throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", this.type.getName(), value.getClass().getName()));
            }
            this.provider = Providers.of(value);
        }
    }

    public Property<T> value(@Nullable T value) {
        this.set(value);
        return this;
    }

    public Property<T> value(Provider<? extends T> provider) {
        this.set(provider);
        return this;
    }

    public void set(Provider<? extends T> provider) {
        if (!this.beforeMutate()) {
            return;
        }
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        Provider p = Providers.internal(provider);
        if (p.getType() != null && !this.type.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using a provider of type %s.", this.type.getName(), p.getType().getName()));
        }
        if (p.getType() == null) {
            p = p.map(new Transformer<T, T>(){

                public T transform(T t) {
                    t = DefaultProperty.this.sanitizer.sanitize(t);
                    if (DefaultProperty.this.type.isInstance(t)) {
                        return t;
                    }
                    throw new IllegalArgumentException(String.format("Cannot get the value of a property of type %s as the provider associated with this property returned a value of type %s.", DefaultProperty.this.type.getName(), t.getClass().getName()));
                }
            });
        }
        this.provider = p;
    }

    public Property<T> convention(T value) {
        ProviderInternal<T> provider = Providers.of(value);
        return this.convention((Provider<? extends T>)provider);
    }

    public Property<T> convention(Provider<? extends T> valueProvider) {
        ProviderInternal<? extends T> providerInternal = Providers.internal(valueProvider);
        if (this.shouldApplyConvention()) {
            this.provider = providerInternal;
        }
        this.convention = providerInternal;
        return this;
    }

    @Override
    protected void applyDefaultValue() {
        this.provider = Providers.notDefined();
    }

    @Override
    protected void makeFinal() {
        this.provider = this.provider.withFinalValue();
        this.convention = Providers.notDefined();
    }

    public T get() {
        this.beforeRead();
        return (T)this.provider.get();
    }

    public T getOrNull() {
        this.beforeRead();
        return (T)this.provider.getOrNull();
    }

    @Override
    public T getOrElse(T defaultValue) {
        this.beforeRead();
        Object t = this.provider.getOrNull();
        if (t == null) {
            return defaultValue;
        }
        return (T)t;
    }

    @Override
    public boolean isPresent() {
        this.beforeRead();
        return this.provider.isPresent();
    }

    @Override
    public String toString() {
        return String.format("property(%s, %s)", this.type, this.provider);
    }
}

