/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import java.io.File;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.configuration.DaemonServerConfiguration;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonServices;
import org.gradle.launcher.daemon.server.MasterExpirationStrategy;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;

public class ForegroundDaemonAction
implements Runnable {
    private final ServiceRegistry loggingRegistry;
    private final DaemonServerConfiguration configuration;

    public ForegroundDaemonAction(ServiceRegistry loggingRegistry, DaemonServerConfiguration configuration) {
        this.loggingRegistry = loggingRegistry;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LoggingManagerInternal loggingManager = this.loggingRegistry.newInstance(LoggingManagerInternal.class);
        loggingManager.start();
        DaemonServices daemonServices = new DaemonServices(this.configuration, this.loggingRegistry, loggingManager, DefaultClassPath.of(new File[0]));
        Daemon daemon = daemonServices.get(Daemon.class);
        DaemonRegistry daemonRegistry = daemonServices.get(DaemonRegistry.class);
        DaemonExpirationStrategy expirationStrategy = daemonServices.get(MasterExpirationStrategy.class);
        daemon.start();
        try {
            daemonRegistry.markState(daemon.getAddress(), DaemonStateControl.State.Idle);
            daemon.stopOnExpiration(expirationStrategy, this.configuration.getPeriodicCheckIntervalMs());
        }
        finally {
            daemon.stop();
        }
    }
}

