/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.request;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.Action;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.cache.internal.DefaultCrossBuildInMemoryCacheFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.dispatch.StreamCompletion;
import org.gradle.internal.event.DefaultListenerManager;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.instantiation.DefaultInstantiatorFactory;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.internal.remote.internal.hub.StreamFailureHandler;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.gradle.process.internal.worker.request.Request;
import org.gradle.process.internal.worker.request.RequestArgumentSerializers;
import org.gradle.process.internal.worker.request.RequestProtocol;
import org.gradle.process.internal.worker.request.RequestSerializerRegistry;
import org.gradle.process.internal.worker.request.ResponseProtocol;

public class WorkerAction
implements Action<WorkerProcessContext>,
Serializable,
RequestProtocol,
StreamFailureHandler,
Stoppable,
StreamCompletion {
    private final String workerImplementationName;
    private transient CountDownLatch completed;
    private transient ResponseProtocol responder;
    private transient Throwable failure;
    private transient Class<?> workerImplementation;
    private transient Object implementation;
    private InstantiatorFactory instantiatorFactory;

    public WorkerAction(Class<?> workerImplementation) {
        this.workerImplementationName = workerImplementation.getName();
    }

    public void execute(WorkerProcessContext workerProcessContext) {
        this.completed = new CountDownLatch(1);
        try {
            if (this.instantiatorFactory == null) {
                this.instantiatorFactory = new DefaultInstantiatorFactory((CrossBuildInMemoryCacheFactory)new DefaultCrossBuildInMemoryCacheFactory((ListenerManager)new DefaultListenerManager()), Collections.emptyList());
            }
            DefaultServiceRegistry serviceRegistry = new DefaultServiceRegistry("worker-action-services", new ServiceRegistry[]{workerProcessContext.getServiceRegistry()});
            RequestArgumentSerializers argumentSerializers = new RequestArgumentSerializers();
            serviceRegistry.add(RequestArgumentSerializers.class, (Object)argumentSerializers);
            workerProcessContext.getServerConnection().useParameterSerializers(RequestSerializerRegistry.create(this.getClass().getClassLoader(), argumentSerializers));
            this.workerImplementation = Class.forName(this.workerImplementationName);
            this.implementation = this.instantiatorFactory.inject((ServiceLookup)serviceRegistry).newInstance(this.workerImplementation, new Object[0]);
        }
        catch (Throwable e) {
            this.failure = e;
        }
        ObjectConnection connection = workerProcessContext.getServerConnection();
        connection.addIncoming(RequestProtocol.class, (Object)this);
        this.responder = (ResponseProtocol)connection.addOutgoing(ResponseProtocol.class);
        connection.connect();
        try {
            this.completed.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.completed.countDown();
        CurrentBuildOperationRef.instance().clear();
    }

    public void endStream() {
        this.stop();
    }

    @Override
    public void runThenStop(Request request) {
        try {
            this.run(request);
        }
        finally {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Request request) {
        if (this.failure != null) {
            this.responder.infrastructureFailed(this.failure);
            return;
        }
        try {
            Object result;
            Method method = this.workerImplementation.getDeclaredMethod(request.getMethodName(), request.getParamTypes());
            CurrentBuildOperationRef.instance().set(request.getBuildOperation());
            try {
                result = method.invoke(this.implementation, request.getArgs());
            }
            catch (InvocationTargetException e) {
                Throwable failure = e.getCause();
                if (failure instanceof NoClassDefFoundError) {
                    this.responder.infrastructureFailed(failure);
                } else {
                    this.responder.failed(failure);
                }
                CurrentBuildOperationRef.instance().clear();
                return;
            }
            this.responder.completed(result);
        }
        catch (Throwable t) {
            this.responder.infrastructureFailed(t);
        }
        finally {
            CurrentBuildOperationRef.instance().clear();
        }
    }

    public void handleStreamFailure(Throwable t) {
        this.responder.failed(t);
    }
}

