/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.util.GUtil;

public class DefaultModuleComponentArtifactIdentifier
implements ModuleComponentArtifactIdentifier,
DisplayName {
    private final ModuleComponentIdentifier componentIdentifier;
    private final IvyArtifactName name;

    public DefaultModuleComponentArtifactIdentifier(ModuleComponentIdentifier componentIdentifier, String name, String type, @Nullable String extension) {
        this(componentIdentifier, new DefaultIvyArtifactName(name, type, extension));
    }

    public DefaultModuleComponentArtifactIdentifier(ModuleComponentIdentifier componentIdentifier, String name, String type, @Nullable String extension, @Nullable String classifier) {
        this(componentIdentifier, new DefaultIvyArtifactName(name, type, extension, classifier));
    }

    public DefaultModuleComponentArtifactIdentifier(ModuleComponentIdentifier componentIdentifier, IvyArtifactName artifact) {
        this.componentIdentifier = componentIdentifier;
        this.name = artifact;
    }

    @Override
    public String getFileName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name.getName());
        builder.append('-');
        builder.append(this.componentIdentifier.getVersion());
        if (GUtil.isTrue((Object)this.name.getClassifier())) {
            builder.append('-');
            builder.append(this.name.getClassifier());
        }
        if (GUtil.isTrue((Object)this.name.getExtension())) {
            builder.append('.');
            builder.append(this.name.getExtension());
        }
        return builder.toString();
    }

    public String getDisplayName() {
        String name = this.name.toString();
        String componentIdentifier = this.componentIdentifier.toString();
        return name + " (" + componentIdentifier + ")";
    }

    public String getCapitalizedDisplayName() {
        return this.getDisplayName();
    }

    public IvyArtifactName getName() {
        return this.name;
    }

    @Override
    public ModuleComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public int hashCode() {
        return this.componentIdentifier.hashCode() ^ this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultModuleComponentArtifactIdentifier other = (DefaultModuleComponentArtifactIdentifier)obj;
        return other.componentIdentifier.equals(this.componentIdentifier) && other.name.equals(this.name);
    }
}

