/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.featurelifecycle.FeatureUsage;

public class DeprecatedFeatureUsage
extends FeatureUsage {
    private final String removalDetails;
    private final String advice;
    private final String contextualAdvice;
    private final Type type;

    public DeprecatedFeatureUsage(String summary, String removalDetails, @Nullable String advice, @Nullable String contextualAdvice, Type type, Class<?> calledFrom) {
        super(summary, calledFrom);
        this.removalDetails = (String)Preconditions.checkNotNull((Object)removalDetails);
        this.advice = advice;
        this.contextualAdvice = contextualAdvice;
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
    }

    @VisibleForTesting
    DeprecatedFeatureUsage(DeprecatedFeatureUsage usage, Exception traceException) {
        super(usage.getSummary(), usage.getCalledFrom(), traceException);
        this.removalDetails = usage.removalDetails;
        this.advice = usage.advice;
        this.contextualAdvice = usage.contextualAdvice;
        this.type = usage.type;
    }

    public String getRemovalDetails() {
        return this.removalDetails;
    }

    @Nullable
    public String getAdvice() {
        return this.advice;
    }

    @Nullable
    public String getContextualAdvice() {
        return this.contextualAdvice;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String formattedMessage() {
        StringBuilder outputBuilder = new StringBuilder(this.getSummary());
        this.append(outputBuilder, this.removalDetails);
        this.append(outputBuilder, this.contextualAdvice);
        this.append(outputBuilder, this.advice);
        return outputBuilder.toString();
    }

    private void append(StringBuilder outputBuilder, String message) {
        if (!StringUtils.isEmpty((String)message)) {
            outputBuilder.append(" ").append(message);
        }
    }

    public static enum Type {
        USER_CODE_DIRECT,
        USER_CODE_INDIRECT,
        BUILD_INVOCATION;

    }
}

