/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.report.BuildReportICReporter;
import org.jetbrains.kotlin.daemon.report.CompileIterationICReporter;
import org.jetbrains.kotlin.daemon.report.CompositeICReporter;
import org.jetbrains.kotlin.daemon.report.DebugMessagesICReporter;
import org.jetbrains.kotlin.daemon.report.GetICReporterKt$WhenMappings;
import org.jetbrains.kotlin.daemon.report.RemoteICReporter;
import org.jetbrains.kotlin.incremental.ICReporter;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\b"}, d2={"getICReporter", "Lorg/jetbrains/kotlin/daemon/report/RemoteICReporter;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/IncrementalCompilationOptions;", "daemon"})
public final class GetICReporterKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RemoteICReporter getICReporter(@NotNull CompilerServicesFacadeBase servicesFacade, @NotNull CompilationResults compilationResults, @NotNull IncrementalCompilationOptions compilationOptions) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkParameterIsNotNull((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkParameterIsNotNull((Object)compilationResults, (String)"compilationResults");
        Intrinsics.checkParameterIsNotNull((Object)compilationOptions, (String)"compilationOptions");
        File root2 = compilationOptions.getModulesInfo().getProjectRoot();
        ArrayList<DebugMessagesICReporter> reporters = new ArrayList<DebugMessagesICReporter>();
        if (ArraysKt.contains((Object[])compilationOptions.getReportCategories(), (Object)ReportCategory.IC_MESSAGE.getCode())) {
            boolean isVerbose = compilationOptions.getReportSeverity() == ReportSeverity.DEBUG.getCode();
            reporters.add(new DebugMessagesICReporter(servicesFacade, root2, isVerbose));
        }
        Integer[] integerArray = compilationOptions.getRequestedCompilationResults();
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach2 = false;
        void var11_15 = $this$forEach$iv$iv;
        int n = ((void)var11_15).length;
        for (int i = 0; i < n; ++i) {
            CompilationResultCategory compilationResultCategory;
            void element$iv$iv;
            void element$iv = element$iv$iv = var11_15[i];
            boolean bl = false;
            int resultCode = ((Number)element$iv).intValue();
            boolean bl2 = false;
            if ((CompilationResultCategory)((Object)ArraysKt.getOrNull((Object[])CompilationResultCategory.values(), (int)resultCode)) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            CompilationResultCategory it$iv = compilationResultCategory;
            boolean bl5 = false;
            destination$iv.add(it$iv);
        }
        HashSet requestedResults = (HashSet)destination$iv;
        Iterable $this$mapTo$iv = requestedResults;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            ICReporter iCReporter;
            void requestedResult;
            CompilationResultCategory $i$f$forEach2 = (CompilationResultCategory)((Object)item$iv);
            Collection collection = reporters;
            boolean bl = false;
            switch (GetICReporterKt$WhenMappings.$EnumSwitchMapping$0[requestedResult.ordinal()]) {
                case 1: {
                    iCReporter = new CompileIterationICReporter(compilationResults);
                    break;
                }
                case 2: {
                    iCReporter = new BuildReportICReporter(compilationResults, root2, false, 4, null);
                    break;
                }
                case 3: {
                    iCReporter = new BuildReportICReporter(compilationResults, root2, true);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            ICReporter iCReporter2 = iCReporter;
            collection.add(iCReporter2);
        }
        return new CompositeICReporter((Iterable<? extends RemoteICReporter>)reporters);
    }
}

