/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Set;

public class ClassAnalysis {
    private final String className;
    private final Set<String> classDependencies;
    private final boolean dependencyToAll;
    private final IntSet constants;

    public ClassAnalysis(String className, Set<String> classDependencies, boolean dependencyToAll, IntSet constants) {
        this.className = className;
        this.classDependencies = ImmutableSet.copyOf(classDependencies);
        this.dependencyToAll = dependencyToAll;
        this.constants = constants.isEmpty() ? IntSets.EMPTY_SET : constants;
    }

    public String getClassName() {
        return this.className;
    }

    public Set<String> getClassDependencies() {
        return this.classDependencies;
    }

    public IntSet getConstants() {
        return this.constants;
    }

    public boolean isDependencyToAll() {
        return this.dependencyToAll;
    }
}

